/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.report;

import de.obqo.decycle.check.Constraint;
import de.obqo.decycle.graph.Graph;
import de.obqo.decycle.graph.Slicing;
import de.obqo.decycle.model.Edge;
import de.obqo.decycle.model.Node;
import de.obqo.decycle.report.FontMetricsSupport;
import de.obqo.decycle.report.ImprovedTextEscaper;
import de.obqo.decycle.report.MarkupReader;
import de.obqo.decycle.report.svg.DynIdAttribute;
import de.obqo.decycle.report.svg.GenericSvgTag;
import de.obqo.decycle.report.svg.MarkerTag;
import de.obqo.decycle.report.svg.PathBuilder;
import de.obqo.decycle.report.svg.PathTag;
import de.obqo.decycle.report.svg.SvgTag;
import de.obqo.decycle.report.svg.SvgTagBuilder;
import de.obqo.decycle.report.svg.TextTag;
import de.obqo.decycle.report.svg.UseTag;
import j2html.Config;
import j2html.TagCreator;
import j2html.rendering.FlatHtml;
import j2html.rendering.HtmlBuilder;
import j2html.rendering.IndentedHtml;
import j2html.tags.DomContent;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.DdTag;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.DlTag;
import j2html.tags.specialized.DtTag;
import j2html.tags.specialized.H1Tag;
import j2html.tags.specialized.HtmlTag;
import j2html.tags.specialized.ITag;
import j2html.tags.specialized.LiTag;
import j2html.tags.specialized.LinkTag;
import j2html.tags.specialized.MetaTag;
import j2html.tags.specialized.ScriptTag;
import j2html.tags.specialized.SpanTag;
import j2html.tags.specialized.StyleTag;
import j2html.tags.specialized.UlTag;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HtmlReport {
    private static final SliceComparator SLICE_COMPARATOR = new SliceComparator();
    private final boolean minify;

    public void writeReport(Graph graph, List<Constraint.Violation> violations, Appendable out, String title) {
        DynIdAttribute.resetDynIds();
        HtmlTag html = this.buildHtml(graph, violations, title);
        Config config = Config.defaults().withTextEscaper(ImprovedTextEscaper::escape);
        try {
            html.render((HtmlBuilder)(this.minify ? FlatHtml.into((Appendable)out, (Config)config) : IndentedHtml.into((Appendable)out, (Config)config)));
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
    }

    private HtmlTag buildHtml(Graph graph, List<Constraint.Violation> violations, String title) {
        Stream<DomContent> sliceSections = graph.sliceTypes().stream().filter(Predicate.not("Class"::equals)).sorted(SLICE_COMPARATOR).map(sliceType -> this.buildSliceSection(graph, violations, (String)sliceType));
        return (HtmlTag)((HtmlTag)TagCreator.html().withLang("en")).with(new DomContent[]{TagCreator.head((DomContent[])new DomContent[]{TagCreator.meta().withCharset("UTF-8"), ((MetaTag)TagCreator.meta().withName("viewport")).withContent("width=device-width, initial-scale=1, shrink-to-fit=no"), TagCreator.title((String)((String)(title != null ? title + " - " : "") + "Decycle Report")), ((LinkTag)((LinkTag)TagCreator.link().withHref("data:image/svg+xml;base64," + MarkupReader.base64FromFile_min("/report/icon.svg"))).withRel("icon")).withType("image/svg+xml"), ((LinkTag)((LinkTag)((LinkTag)TagCreator.link().withRel("stylesheet")).withHref("https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css")).attr("integrity", (Object)"sha384-B0vP5xmATw1+K9KRQjQERJvTumQW0nPEzvF6L/Z6nronJ3oUOFUFpCjEUQouq2+l")).attr("crossorigin", (Object)"anonymous"), ((LinkTag)TagCreator.link().withRel("stylesheet")).withHref("https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css"), this.inlineStyle(this.minify, "/report/custom.css"), ((ScriptTag)((ScriptTag)TagCreator.script().withSrc("https://code.jquery.com/jquery-3.6.0.min.js")).attr("integrity", (Object)"sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=")).attr("crossorigin", (Object)"anonymous"), this.inlineScript(this.minify, "/report/custom.js")}), TagCreator.body((DomContent[])new DomContent[]{((DivTag)TagCreator.div().withClass("container-fluid p-3")).with((DomContent)((DivTag)TagCreator.div().withClass("mx-2")).with(new DomContent[]{this.inlineMarkup(this.minify, "/report/logo.svg"), TagCreator.hr().withClass("mt-1"), ((H1Tag)TagCreator.h1().withClass("mb-3")).withText("Violation Report" + (String)(title != null ? " for " + title : "")), this.buildViolationDiv(violations), ((DivTag)TagCreator.div().withClass("row")).with(TagCreator.each(violations, vio -> this.buildDependencyImage(vio.getViolatingSubgraph()))), TagCreator.each(sliceSections), TagCreator.hr().withClass("row"), ((DivTag)TagCreator.div().withClass("footer small")).with(new DomContent[]{TagCreator.text((String)"Generated by "), ((ATag)((ATag)TagCreator.a().withHref("https://github.com/obecker/decycle")).withTarget("decycle")).withText("Decycle"), TagCreator.text((String)" "), TagCreator.text((String)HtmlReport.class.getPackage().getImplementationVersion())})}))})});
    }

    private StyleTag inlineStyle(boolean minify, String path) {
        return minify ? TagCreator.styleWithInlineFile_min((String)path) : TagCreator.styleWithInlineFile((String)path);
    }

    private ScriptTag inlineScript(boolean minify, String path) {
        return minify ? TagCreator.scriptWithInlineFile_min((String)path) : TagCreator.scriptWithInlineFile((String)path);
    }

    private DomContent inlineMarkup(boolean minify, String path) {
        return minify ? MarkupReader.rawHtmlWithInlineFile_min(path) : MarkupReader.rawHtmlWithInlineFile(path);
    }

    private DomContent buildViolationDiv(List<Constraint.Violation> violations) {
        return violations.isEmpty() ? ((DivTag)TagCreator.div().withClass("violations border rounded-lg pb-1 mb-3 alert-success row")).with(new DomContent[]{((H1Tag)TagCreator.h1().withClass("m-0 pt-2")).with((DomContent)TagCreator.i().withClass("bi bi-check-circle-fill")), ((DivTag)TagCreator.div().withClass("col-12 mt-1")).with((DomContent)TagCreator.b((String)"No violations found"))}) : ((DivTag)TagCreator.div().withClass("violations border rounded-lg pb-1 mb-3 alert-danger row")).with(new DomContent[]{((H1Tag)TagCreator.h1().withClass("m-0 pt-2")).with((DomContent)TagCreator.i().withClass("bi bi-exclamation-triangle-fill")), TagCreator.each(violations.stream().sorted(Comparator.comparing(Constraint.Violation::getSliceType, SLICE_COMPARATOR).thenComparing(Constraint.Violation::getName)).flatMap(this::buildViolationDivColumns))});
    }

    private Stream<DomContent> buildViolationDivColumns(Constraint.Violation v) {
        return Stream.of(((DivTag)TagCreator.div().withClass("col-4 name mt-1")).with((DomContent)TagCreator.b((String)this.replaceArrows(v.getName()))), ((DivTag)TagCreator.div().withClass("col-8 dependencies mt-1")).with(v.getDependencies().stream().map(dependency -> TagCreator.div((DomContent[])new DomContent[]{((ATag)TagCreator.a((String)dependency.displayString()).withHref("#" + v.getSliceType() + "-" + dependency.getFrom().getName())).withClass("alert-link")}))));
    }

    private String replaceArrows(String name) {
        return name.replace("->", "\u2192").replace("=>", "\u21e8");
    }

    private DomContent buildSliceSection(Graph graph, List<Constraint.Violation> violations, String sliceType) {
        Map violationsIndex = violations.stream().filter(v -> v.getSliceType().equals(sliceType)).flatMap(v -> v.getDependencies().stream().map(d -> Map.entry(d.getFrom().getName(), Map.entry(d.getTo().getName(), v.getName())))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())))));
        Slicing slicing = graph.slicing(sliceType);
        return ((DivTag)TagCreator.div().withClass("pt-2")).with(new DomContent[]{TagCreator.h2((String)sliceType).withClass("slice text-capitalize mt-2"), ((DlTag)TagCreator.dl().withClass("slices row border rounded-lg py-1")).with(slicing.nodes().stream().sorted().flatMap(node -> this.buildNodeTableRow(graph, slicing, violationsIndex, (Node)node))), ((DivTag)TagCreator.div().withClass("row")).with((DomContent)this.buildDependencyImage(slicing))});
    }

    private SvgTag buildDependencyImage(Slicing slicing) {
        List<Node> nodeList = slicing.orderedNodes();
        FontMetricsSupport metrics = FontMetricsSupport.get(this.minify);
        int maxTextWidth = nodeList.stream().map(Node::getName).mapToInt(metrics::widthOf).max().orElse(0);
        int verticalDistance = 420;
        int boxWidth = maxTextWidth + 100;
        int boxHeight = 200;
        int arrowSpacing = 60;
        int arrowLength = 55;
        int xShrinkFactor = 2;
        int svgShrinkFactor = 8;
        int totalPadding = 100;
        int totalHeight = (nodeList.size() - 1) * 420 + 200 + 200;
        int arcSpace = totalHeight / 2 / 2 + 55 - 50;
        int totalWidth = boxWidth + 2 * (arcSpace + 100);
        int leftBox = arcSpace + 100;
        int rightBox = leftBox + boxWidth;
        int centerBox = leftBox + boxWidth / 2;
        HashMap nodePositionMap = new HashMap();
        String arrowHead = "M85.2 50 21.2 82a4.8 4.8 0 0 1-6.4-4.8l6.4-28.16-6.4-28.16a4.8 4.8 0 0 1 6.4-4.8z";
        return (SvgTag)((SvgTag)SvgTagBuilder.svg().widthAndHeight(totalWidth / 8, totalHeight / 8).viewBox(0.0, 0.0, totalWidth, totalHeight).withClass("dependency-graph border rounded mr-3")).with(new DomContent[]{SvgTagBuilder.defs().with(new DomContent[]{((MarkerTag)SvgTagBuilder.marker().attr(DynIdAttribute.dynId("af"))).markerWidth(100.0).markerHeight(100.0).refX(28.0).refY(50.0).orient("auto").markerUnits("userSpaceOnUse").with((DomContent)((PathTag)SvgTagBuilder.path().fill("black")).d("M85.2 50 21.2 82a4.8 4.8 0 0 1-6.4-4.8l6.4-28.16-6.4-28.16a4.8 4.8 0 0 1 6.4-4.8z")), ((MarkerTag)SvgTagBuilder.marker().attr(DynIdAttribute.dynId("ab"))).markerWidth(100.0).markerHeight(100.0).refX(28.0).refY(50.0).orient("auto").markerUnits("userSpaceOnUse").with((DomContent)((PathTag)SvgTagBuilder.path().fill("#721c24")).d("M85.2 50 21.2 82a4.8 4.8 0 0 1-6.4-4.8l6.4-28.16-6.4-28.16a4.8 4.8 0 0 1 6.4-4.8z")), ((GenericSvgTag)((GenericSvgTag)((GenericSvgTag)SvgTagBuilder.linearGradient().attr(DynIdAttribute.dynId("lg"))).attr("x2", 0.0)).attr("y2", "100%")).with(new DomContent[]{SvgTagBuilder.stop().offset(0.0).stopColor("#bbb").stopOpacity(0.1), SvgTagBuilder.stop().offset(1.0).stopOpacity(0.1)}), ((GenericSvgTag)SvgTagBuilder.clipPath().attr(DynIdAttribute.dynId("cl"))).with((DomContent)SvgTagBuilder.rect().widthAndHeight(boxWidth, 200.0).rx(35.0)), ((GenericSvgTag)((GenericSvgTag)SvgTagBuilder.g().attr(DynIdAttribute.dynId("box"))).clipPath(DynIdAttribute.url("cl"))).with(new DomContent[]{SvgTagBuilder.rect().widthAndHeight(boxWidth, 200.0).fill("#c6d8ec"), SvgTagBuilder.rect().widthAndHeight(boxWidth, 200.0).fill(DynIdAttribute.url("lg"))})}), TagCreator.each(nodeList, (index, node) -> {
            int yPos = index * 420 + 100;
            nodePositionMap.put(node, yPos);
            String text = node.getName();
            String hrefTarget = "#" + slicing.getSliceType() + "-" + node.getName();
            return TagCreator.each((DomContent[])new DomContent[]{((UseTag)SvgTagBuilder.use().href(DynIdAttribute.ref("box")).x(leftBox)).y(yPos), ((ATag)((ATag)TagCreator.a().attr("xlink:href", (Object)hrefTarget)).withHref(hrefTarget)).with(new DomContent[]{((TextTag)((TextTag)((TextTag)((TextTag)SvgTagBuilder.text().x(centerBox + 5)).y(150 + yPos)).fill("#F1F1F1")).fillOpacity(0.5)).withText(text), ((TextTag)((TextTag)((TextTag)SvgTagBuilder.text().x(centerBox)).y(140 + yPos)).fill("#000")).withText(text)})});
        }), TagCreator.each(slicing.edges().stream().sorted().map(edge -> {
            int positionTo;
            int positionFrom = (Integer)nodePositionMap.get(edge.getFrom());
            if (positionFrom < (positionTo = ((Integer)nodePositionMap.get(edge.getTo())).intValue())) {
                return ((PathTag)((PathTag)((PathTag)((PathTag)((PathTag)SvgTagBuilder.path().d(PathBuilder.from(rightBox, (double)positionFrom + 130.0).relHorizontalLineTo(55.0).relArc((double)(positionTo - positionFrom) / 2.0 / 2.0, (double)(positionTo - positionFrom - 60) / 2.0, 180.0, true, true, 0.0, positionTo - positionFrom - 60)).stroke("black")).strokeWidth(HtmlReport.arcWidth(edge))).fill("none")).condAttr(edge.isIgnored(), "stroke-dasharray", 20.0)).condAttr(edge.isIgnored(), "stroke-opacity", 0.7)).markerEnd(DynIdAttribute.url("af"));
            }
            return ((PathTag)((PathTag)((PathTag)((PathTag)((PathTag)SvgTagBuilder.path().d(PathBuilder.from(leftBox, (double)positionFrom + 70.0).relHorizontalLineTo(-55.0).relArc((double)(positionFrom - positionTo) / 2.0 / 2.0, (double)(positionFrom - positionTo - 60) / 2.0, 180.0, true, true, 0.0, positionTo - positionFrom + 60)).stroke("#721c24")).strokeWidth(HtmlReport.arcWidth(edge))).fill("none")).condAttr(edge.isIgnored(), "stroke-dasharray", 20.0)).condAttr(edge.isIgnored(), "stroke-opacity", 0.7)).markerEnd(DynIdAttribute.url("ab"));
        }))});
    }

    private static double arcWidth(Edge edge) {
        return Math.log1p(edge.getWeight()) * 6.0;
    }

    private Stream<DomContent> buildNodeTableRow(Graph graph, Slicing slicing, Map<String, Map<String, List<String>>> violationsIndex, Node node) {
        Map<String, List<String>> fromViolations = violationsIndex.getOrDefault(node.getName(), Map.of());
        String errorClass = fromViolations.isEmpty() ? "" : "error";
        return Stream.of(((DtTag)((DtTag)TagCreator.dt().withClasses(new String[]{"col-sm-4", "border-top", "py-1", "text-truncate", errorClass})).withTitle(node.getName())).with((DomContent)TagCreator.a((String)node.getName()).withId(node.getType() + "-" + node.getName())), ((DdTag)TagCreator.dd().withClasses(new String[]{"col-sm-8", "border-top", "py-1", "mb-0", errorClass})).with((DomContent)((UlTag)TagCreator.ul().withClass("references list-unstyled mb-0")).with(this.buildOutEdgesList(graph, slicing, node, fromViolations))));
    }

    private Stream<DomContent> buildOutEdgesList(Graph graph, Slicing slicing, Node node, Map<String, List<String>> fromViolations) {
        return slicing.outEdges(node).stream().sorted().map(edge -> {
            List toViolations = fromViolations.getOrDefault(edge.getTo().getName(), List.of());
            boolean hasViolations = !toViolations.isEmpty();
            return ((LiTag)TagCreator.li().withClasses(new String[]{"pb-1", (String)TagCreator.iff((boolean)hasViolations, (Object)"error")})).with(new DomContent[]{((ATag)TagCreator.a().withClass("mr-2 toggle-display")).with(new DomContent[]{((ITag)TagCreator.i().withClasses(new String[]{"bi", "bi-arrows-expand", (String)TagCreator.iff((boolean)hasViolations, (Object)"hidden")})).withTitle("Show class dependencies"), ((ITag)TagCreator.i().withClasses(new String[]{"bi", "bi-arrows-collapse", (String)TagCreator.iff((!hasViolations ? 1 : 0) != 0, (Object)"hidden")})).withTitle("Hide class dependencies")}), ((ATag)((ATag)TagCreator.a().withHref("#" + slicing.getSliceType() + "-" + edge.getTo().getName())).withClass("mr-2")).with(HtmlReport.wrap(edge.isIgnored(), TagCreator::del, new DomContent[]{TagCreator.text((String)edge.getTo().getName())})), (DomContent)TagCreator.iff((boolean)hasViolations, (Object)TagCreator.span((DomContent[])new DomContent[]{TagCreator.text((String)" "), TagCreator.i().withClass("bi bi-exclamation-triangle-fill"), TagCreator.text((String)toViolations.stream().collect(Collectors.joining(", ", " (", ")")))})), ((UlTag)TagCreator.ul().withClass("class-references list-unstyled mb-1")).with(graph.containingClassEdges((Edge)edge).stream().sorted().map(classEdge -> TagCreator.li((DomContent[])new DomContent[]{HtmlReport.wrap(classEdge.isIgnored(), TagCreator::del, new DomContent[]{((SpanTag)((SpanTag)TagCreator.span().withClass("class-node")).withData("name", classEdge.getFrom().getName())).withText(classEdge.getFrom().getName()), TagCreator.rawHtml((String)" &rarr;&nbsp;"), ((SpanTag)((SpanTag)TagCreator.span().withClass("class-node")).withData("name", classEdge.getTo().getName())).withText(classEdge.getTo().getName())})})))});
        });
    }

    private static DomContent wrap(boolean condition, Function<DomContent[], DomContent> wrapper, DomContent ... contents) {
        return condition ? wrapper.apply(contents) : TagCreator.each((DomContent[])contents);
    }

    public HtmlReport(boolean minify) {
        this.minify = minify;
    }

    private static class SliceComparator
    implements Comparator<String> {
        private SliceComparator() {
        }

        @Override
        public int compare(String slice1, String slice2) {
            if ("Package".equals(slice1)) {
                return -1;
            }
            if ("Package".equals(slice2)) {
                return 1;
            }
            return slice1.compareTo(slice2);
        }
    }
}

