/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.analysis;

import com.google.common.base.Preconditions;
import de.obqo.decycle.graph.Graph;
import de.obqo.decycle.model.Node;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;

class GraphBuilder {
    private static final Pattern singlePattern = Pattern.compile("\\[*L([\\w/$]+);");
    private static final Pattern multiPattern = Pattern.compile("(?<=L)([\\w/$]+)(?=[;<])");
    private final Graph graph;
    private Node currentNode;

    void visitCurrentClass(String slashSeparatedName) {
        Preconditions.checkState((this.currentNode == null ? 1 : 0) != 0, (Object)"Can only visit one class per GraphBuilder");
        this.currentNode = GraphBuilder.classNodeFromTypeName(slashSeparatedName);
    }

    static Node classNodeFromTypeName(String slashSeparatedName) {
        return Node.classNode(slashSeparatedName.replace('/', '.'));
    }

    static Node classNodeFromSingleType(String singleTypeDescription) {
        Matcher matcher = singlePattern.matcher(singleTypeDescription);
        if (matcher.matches()) {
            return GraphBuilder.classNodeFromTypeName(matcher.group(1));
        }
        return GraphBuilder.classNodeFromTypeName(singleTypeDescription);
    }

    void connect(Node node) {
        this.graph.connect(this.currentNode, node);
    }

    void connectNodesFromDescriptors(String ... descriptors) {
        this.classNodeFromDescriptors(descriptors).forEach(this::connect);
    }

    private Set<Node> classNodeFromDescriptors(String ... descriptors) {
        HashSet<Node> result = new HashSet<Node>();
        for (String descriptor : descriptors) {
            if (descriptor == null || descriptor.isEmpty()) continue;
            Matcher matcher = multiPattern.matcher(descriptor);
            while (matcher.find()) {
                result.add(GraphBuilder.classNodeFromTypeName(matcher.group()));
            }
        }
        return result;
    }

    void connectValue(Object value) {
        if (value instanceof Type) {
            this.connectNodesFromDescriptors(((Type)value).getDescriptor());
        } else if (value instanceof Handle) {
            Handle handle = (Handle)value;
            this.connect(GraphBuilder.classNodeFromTypeName(handle.getOwner()));
            this.connectNodesFromDescriptors(handle.getDesc());
        } else if (value instanceof ConstantDynamic) {
            ConstantDynamic constantDynamic = (ConstantDynamic)value;
            this.connectNodesFromDescriptors(constantDynamic.getDescriptor());
            for (int i = 0; i < constantDynamic.getBootstrapMethodArgumentCount(); ++i) {
                this.connectValue(constantDynamic.getBootstrapMethodArgument(i));
            }
        }
    }

    public GraphBuilder(Graph graph) {
        this.graph = graph;
    }
}

