/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.configuration;

import de.obqo.decycle.configuration.Pattern;
import de.obqo.decycle.slicer.Categorizer;
import de.obqo.decycle.slicer.NamedPatternMatchingCategorizer;
import java.util.logging.Logger;

public class NamedPattern
implements Pattern {
    private static final Logger log = Logger.getLogger(NamedPattern.class.getName());
    private final String name;
    private final String pattern;

    public NamedPattern(String name, String pattern) {
        if (name.contains("*") || name.contains(".")) {
            log.warning("Looks like you use the pattern '" + name + "' as the NAME of a NamedPattern. Please note that the NAME comes first in such a pattern.");
        }
        this.name = name;
        this.pattern = pattern;
    }

    @Override
    public Categorizer toCategorizer(String sliceType) {
        return new NamedPatternMatchingCategorizer(sliceType, this.name, this.pattern);
    }

    public String toString() {
        return this.name + "=" + this.pattern;
    }
}

