/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.model;

import com.google.common.annotations.VisibleForTesting;
import de.obqo.decycle.model.Node;
import java.util.Comparator;

public class Edge
implements Comparable<Edge> {
    public static final Comparator<Edge> COMPARATOR = Comparator.comparing(Edge::getFrom).thenComparing(Edge::getTo);
    private final Node from;
    private final Node to;
    private final EdgeLabel label;
    private boolean ignored;
    private int weight = 1;
    private boolean violating = false;

    public static Edge references(Node from, Node to, boolean ignored) {
        return new Edge(from, to, EdgeLabel.REFERENCES, ignored);
    }

    @VisibleForTesting
    public static Edge references(Node from, Node to) {
        return new Edge(from, to, EdgeLabel.REFERENCES, false);
    }

    public static Edge contains(Node from, Node to) {
        return new Edge(from, to, EdgeLabel.CONTAINS, false);
    }

    private Edge(Node from, Node to, EdgeLabel label, boolean ignored) {
        this.from = from;
        this.to = to;
        this.label = label;
        this.ignored = ignored;
    }

    public boolean isReferencing() {
        return this.label == EdgeLabel.REFERENCES;
    }

    public boolean isContaining() {
        return this.label == EdgeLabel.CONTAINS;
    }

    public void combine(Edge edge) {
        this.ignored &= edge.isIgnored();
        this.weight += edge.weight;
    }

    public void setViolating() {
        this.violating = true;
    }

    public boolean isIncluded() {
        return !this.isIgnored() && !this.isViolating();
    }

    public String displayString() {
        return this.from.displayString() + " \u2192 " + this.to.displayString();
    }

    @Override
    public int compareTo(Edge other) {
        return COMPARATOR.compare(this, other);
    }

    public Node getFrom() {
        return this.from;
    }

    public Node getTo() {
        return this.to;
    }

    public EdgeLabel getLabel() {
        return this.label;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isViolating() {
        return this.violating;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Edge)) {
            return false;
        }
        Edge other = (Edge)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Node this$from = this.getFrom();
        Node other$from = other.getFrom();
        if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
            return false;
        }
        Node this$to = this.getTo();
        Node other$to = other.getTo();
        if (this$to == null ? other$to != null : !((Object)this$to).equals(other$to)) {
            return false;
        }
        EdgeLabel this$label = this.getLabel();
        EdgeLabel other$label = other.getLabel();
        return !(this$label == null ? other$label != null : !((Object)((Object)this$label)).equals((Object)other$label));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Edge;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Node $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        Node $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
        EdgeLabel $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : ((Object)((Object)$label)).hashCode());
        return result;
    }

    public static enum EdgeLabel {
        CONTAINS,
        REFERENCES;

    }
}

