/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.slicer;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class PatternMatcher {
    private final Pattern pattern;

    public PatternMatcher(String pattern) {
        this(pattern, false);
    }

    public PatternMatcher(String pattern, boolean strict) {
        Preconditions.checkNotNull((Object)pattern, (Object)"pattern string must not be null");
        this.pattern = Pattern.compile(PatternMatcher.ensureParens(PatternMatcher.escapeStars(PatternMatcher.escapeDots(pattern)), strict));
    }

    public Optional<String> matches(String name) {
        Matcher matcher = this.pattern.matcher(name);
        return matcher.matches() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    private static String ensureParens(String p, boolean strict) {
        if (strict && Pattern.matches(".*\\(.*\\(.*", p)) {
            throw new IllegalArgumentException("More than one pair of parentheses is not a supported pattern.");
        }
        return Pattern.matches(".*\\(.*\\).*", p) ? p : "(" + p + ")";
    }

    private static String escapeStars(String p) {
        if (p.contains("***")) {
            throw new IllegalArgumentException("More than two '*'s in a row is not a supported pattern.");
        }
        String doubleStarPlaceHolder = PatternMatcher.getPlaceHolder(p);
        String singleStarPlaceHolder = PatternMatcher.getPlaceHolder(p + doubleStarPlaceHolder);
        return p.replace("**", doubleStarPlaceHolder).replace("*", singleStarPlaceHolder).replace(doubleStarPlaceHolder, ".*").replace(singleStarPlaceHolder, "[^.]*");
    }

    private static String getPlaceHolder(String pattern) {
        char c = '\u0001';
        while (pattern.indexOf(c) >= 0) {
            c = (char)(c + '\u0001');
        }
        return String.valueOf(c);
    }

    private static String escapeDots(String p) {
        return p.replace(".", "\\.");
    }
}

