/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.configuration;

import de.obqo.decycle.analysis.Analyzer;
import de.obqo.decycle.analysis.IncludeExcludeFilter;
import de.obqo.decycle.check.Constraint;
import de.obqo.decycle.check.CycleFree;
import de.obqo.decycle.configuration.Pattern;
import de.obqo.decycle.graph.Graph;
import de.obqo.decycle.model.EdgeFilter;
import de.obqo.decycle.model.NodeFilter;
import de.obqo.decycle.report.HtmlReport;
import de.obqo.decycle.slicer.Categorizer;
import de.obqo.decycle.slicer.IgnoredDependenciesFilter;
import de.obqo.decycle.slicer.IgnoredDependency;
import de.obqo.decycle.slicer.MultiCategorizer;
import de.obqo.decycle.slicer.PackageCategorizer;
import de.obqo.decycle.slicer.ParallelCategorizer;
import de.obqo.decycle.slicer.PatternMatchingNodeFilter;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;

public class Configuration {
    @NonNull
    private final String classpath;
    private final List<String> including;
    private final List<String> excluding;
    private final List<IgnoredDependency> ignoring;
    private final Map<String, List<Pattern>> slicings;
    private final Set<Constraint> constraints;
    private final Appendable report;
    private final String reportResourcesPrefix;
    private final String reportTitle;
    private final boolean minifyReport;
    private final Graph graph;

    private Configuration(String classpath, List<String> including, List<String> excluding, List<IgnoredDependency> ignoring, Map<String, List<Pattern>> slicings, Set<Constraint> constraints, Appendable report, String reportResourcesPrefix, String reportTitle, Boolean minifyReport) {
        this.classpath = classpath;
        this.including = Objects.requireNonNullElse(including, List.of());
        this.excluding = Objects.requireNonNullElse(excluding, List.of());
        this.slicings = Objects.requireNonNullElse(slicings, Map.of());
        this.ignoring = Objects.requireNonNullElse(ignoring, List.of());
        this.constraints = Objects.requireNonNullElse(constraints, Set.of());
        this.report = report;
        this.reportResourcesPrefix = Objects.requireNonNullElse(reportResourcesPrefix, ".");
        this.reportTitle = reportTitle;
        this.minifyReport = !Boolean.FALSE.equals(minifyReport);
        this.validate();
        this.graph = this.createGraph();
    }

    private void validate() {
        this.slicings.forEach((sliceType, patterns) -> {
            if (patterns.isEmpty()) {
                throw new IllegalArgumentException("Slicing '" + sliceType + "' has no pattern definition");
            }
        });
    }

    private Graph createGraph() {
        return new Analyzer().analyze(this.classpath, this.buildCategorizer(), this.buildNodeFilter(), this.buildEdgeFilters());
    }

    private Categorizer buildCategorizer() {
        Stream<Categorizer> slicers = this.slicings.entrySet().stream().map(entry -> this.buildSlicing((String)entry.getKey(), (List)entry.getValue()));
        Stream<Categorizer> slicersWithPackages = Stream.concat(Stream.of(new PackageCategorizer()), slicers);
        return ParallelCategorizer.parallel((Categorizer[])slicersWithPackages.toArray(Categorizer[]::new));
    }

    private Categorizer buildSlicing(String sliceType, List<Pattern> patterns) {
        return MultiCategorizer.combine((Categorizer[])patterns.stream().map(p -> p.toCategorizer(sliceType)).toArray(Categorizer[]::new));
    }

    private NodeFilter buildNodeFilter() {
        return new IncludeExcludeFilter(this.including.stream().map(PatternMatchingNodeFilter::new).collect(Collectors.toSet()), this.excluding.stream().map(PatternMatchingNodeFilter::new).collect(Collectors.toSet()));
    }

    private EdgeFilter buildEdgeFilters() {
        return new IgnoredDependenciesFilter(this.ignoring);
    }

    public List<Constraint.Violation> check() {
        Stream<CycleFree> allConstraints = Stream.concat(Stream.of(new CycleFree()), this.constraints.stream());
        List<Constraint.Violation> violations = allConstraints.flatMap(c -> c.violations(this.graph).stream()).sorted(Comparator.comparing(Constraint.Violation::getSliceType).thenComparing(Constraint.Violation::getName)).collect(Collectors.toList());
        if (this.report != null) {
            new HtmlReport(this.minifyReport).writeReport(this.graph, violations, this.report, this.reportResourcesPrefix, this.reportTitle);
        }
        return violations;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Decycle {\n");
        builder.append("  classpath: ").append(this.classpath).append("\n");
        builder.append("  including: ").append(this.including).append("\n");
        builder.append("  excluding: ").append(this.excluding).append("\n");
        builder.append("  ignoring: ").append(this.ignoring).append("\n");
        builder.append("  slicings: ").append(this.slicings).append("\n");
        builder.append("  constraints: ").append(this.constraints).append("\n");
        builder.append("}");
        return builder.toString();
    }

    public static ConfigurationBuilder builder() {
        return new ConfigurationBuilder();
    }

    public static class ConfigurationBuilder {
        private String classpath;
        private List<String> including;
        private List<String> excluding;
        private List<IgnoredDependency> ignoring;
        private Map<String, List<Pattern>> slicings;
        private Set<Constraint> constraints;
        private Appendable report;
        private String reportResourcesPrefix;
        private String reportTitle;
        private Boolean minifyReport;

        ConfigurationBuilder() {
        }

        public ConfigurationBuilder classpath(String classpath) {
            this.classpath = classpath;
            return this;
        }

        public ConfigurationBuilder including(List<String> including) {
            this.including = including;
            return this;
        }

        public ConfigurationBuilder excluding(List<String> excluding) {
            this.excluding = excluding;
            return this;
        }

        public ConfigurationBuilder ignoring(List<IgnoredDependency> ignoring) {
            this.ignoring = ignoring;
            return this;
        }

        public ConfigurationBuilder slicings(Map<String, List<Pattern>> slicings) {
            this.slicings = slicings;
            return this;
        }

        public ConfigurationBuilder constraints(Set<Constraint> constraints) {
            this.constraints = constraints;
            return this;
        }

        public ConfigurationBuilder report(Appendable report) {
            this.report = report;
            return this;
        }

        public ConfigurationBuilder reportResourcesPrefix(String reportResourcesPrefix) {
            this.reportResourcesPrefix = reportResourcesPrefix;
            return this;
        }

        public ConfigurationBuilder reportTitle(String reportTitle) {
            this.reportTitle = reportTitle;
            return this;
        }

        public ConfigurationBuilder minifyReport(Boolean minifyReport) {
            this.minifyReport = minifyReport;
            return this;
        }

        public Configuration build() {
            return new Configuration(this.classpath, this.including, this.excluding, this.ignoring, this.slicings, this.constraints, this.report, this.reportResourcesPrefix, this.reportTitle, this.minifyReport);
        }

        public String toString() {
            return "Configuration.ConfigurationBuilder(classpath=" + this.classpath + ", including=" + this.including + ", excluding=" + this.excluding + ", ignoring=" + this.ignoring + ", slicings=" + this.slicings + ", constraints=" + this.constraints + ", report=" + this.report + ", reportResourcesPrefix=" + this.reportResourcesPrefix + ", reportTitle=" + this.reportTitle + ", minifyReport=" + this.minifyReport + ")";
        }
    }
}

