/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.configuration;

import de.obqo.decycle.configuration.Pattern;
import de.obqo.decycle.slicer.Categorizer;
import de.obqo.decycle.slicer.PatternMatchingCategorizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UnnamedPattern
implements Pattern {
    private static final Logger log = LoggerFactory.getLogger(UnnamedPattern.class);
    private final String pattern;

    public UnnamedPattern(String pattern) {
        this.pattern = pattern;
        if (pattern != null && pattern.contains("(") && !pattern.contains("{")) {
            log.warn("Warning: parentheses found instead of curly braces in slicing pattern '{}'. Please check if you need to migrate your patterns when upgrading from 0.7.0 to 0.8.0", (Object)pattern);
        }
    }

    @Override
    public Categorizer toCategorizer(String sliceType) {
        return new PatternMatchingCategorizer(sliceType, this.pattern);
    }

    public String toString() {
        return this.pattern;
    }
}

