/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.graph;

import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import de.obqo.decycle.graph.MutableSlicing;
import de.obqo.decycle.graph.SliceNodeFinder;
import de.obqo.decycle.graph.Slicing;
import de.obqo.decycle.graph.SlicingSource;
import de.obqo.decycle.model.Edge;
import de.obqo.decycle.model.EdgeFilter;
import de.obqo.decycle.model.Node;
import de.obqo.decycle.model.NodeFilter;
import de.obqo.decycle.model.SliceType;
import de.obqo.decycle.slicer.Categorizer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Graph
implements SlicingSource {
    private final Categorizer categorizer;
    private final NodeFilter filter;
    private final EdgeFilter ignoredEdgesFilter;
    private final MutableNetwork<Node, Edge> internalGraph = NetworkBuilder.directed().build();
    private final Map<SliceType, Slicing> slicingCache = new HashMap<SliceType, Slicing>();

    public Graph() {
        this(null);
    }

    public Graph(Categorizer categorizer) {
        this(categorizer, null);
    }

    public Graph(Categorizer categorizer, NodeFilter filter) {
        this(categorizer, filter, null);
    }

    public Graph(Categorizer categorizer, NodeFilter filter, EdgeFilter ignoredEdgesFilter) {
        this.categorizer = Objects.requireNonNullElse(categorizer, Categorizer.EMPTY);
        this.filter = Objects.requireNonNullElse(filter, NodeFilter.ALL);
        this.ignoredEdgesFilter = Objects.requireNonNullElse(ignoredEdgesFilter, EdgeFilter.NONE);
    }

    public void connect(Node a, Node b) {
        this.addReference(a, b);
    }

    private void addReference(Node a, Node b) {
        if (this.filter.test(a) && this.filter.test(b) && !Objects.equals(a, b)) {
            boolean ignored = this.ignoredEdgesFilter.test(a, b);
            this.internalGraph.addEdge((Object)a, (Object)b, (Object)Edge.references(a, b, ignored));
        }
    }

    public void add(Node node) {
        if (this.filter.test(node)) {
            this.addNodeToSlices(node);
        }
    }

    private void addNodeToSlices(Node node) {
        Set categories = (Set)this.categorizer.apply(node);
        if (categories.isEmpty()) {
            this.internalGraph.addNode((Object)node);
        } else {
            categories.forEach(category -> {
                if (!category.equals(node)) {
                    this.internalGraph.addEdge(category, (Object)node, (Object)Edge.contains(category, node));
                    this.addNodeToSlices((Node)category);
                }
            });
        }
    }

    public Set<Node> allNodes() {
        return this.internalGraph.nodes();
    }

    public Set<Node> topNodes() {
        return this.internalGraph.nodes().stream().filter(n -> this.internalGraph.inEdges(n).stream().allMatch(Edge::isReferencing)).collect(Collectors.toSet());
    }

    private Set<Edge> outEdges(Node node) {
        return this.internalGraph.nodes().contains(node) ? this.internalGraph.outEdges((Object)node) : Set.of();
    }

    private Set<Node> connectedNodes(Node node, Edge.EdgeLabel label) {
        return this.outEdges(node).stream().filter(e -> e.getLabel() == label).map(Edge::getTo).collect(Collectors.toSet());
    }

    public Set<Node> contentsOf(Node group) {
        return this.connectedNodes(group, Edge.EdgeLabel.CONTAINS);
    }

    public Set<Node> connectionsOf(Node node) {
        return this.connectedNodes(node, Edge.EdgeLabel.REFERENCES);
    }

    @Override
    public Set<SliceType> sliceTypes() {
        return this.internalGraph.nodes().stream().map(Node::getType).collect(Collectors.toSet());
    }

    @Override
    public Slicing slicing(SliceType sliceType) {
        return this.slicingCache.computeIfAbsent(sliceType, this::computeSlicing);
    }

    private MutableSlicing computeSlicing(SliceType sliceType) {
        MutableSlicing slice = MutableSlicing.create(sliceType);
        SliceNodeFinder sliceNodeFinder = new SliceNodeFinder(sliceType, (Network<Node, Edge>)this.internalGraph);
        this.internalGraph.nodes().stream().filter(n -> n.hasType(sliceType)).forEach(slice::addNode);
        this.internalGraph.edges().stream().filter(Edge::isReferencing).forEach(edge -> sliceNodeFinder.find(edge.getFrom()).ifPresent(n1 -> sliceNodeFinder.find(edge.getTo()).filter(Predicate.not(n1::equals)).ifPresent(n2 -> slice.edgeConnecting((Node)n1, (Node)n2).ifPresentOrElse(slideEdge -> slideEdge.combine((Edge)edge), () -> slice.addEdge(Edge.references(n1, n2, edge.isIgnored()))))));
        return slice;
    }

    public Set<Edge> containingClassEdges(Edge edge) {
        if (!edge.isReferencing()) {
            return Set.of();
        }
        Stream<Node> containingFromNodes = this.containingClassNodes(edge.getFrom());
        Set containingToNodes = this.containingClassNodes(edge.getTo()).collect(Collectors.toSet());
        HashSet<Edge> containingEdges = new HashSet<Edge>();
        containingFromNodes.forEach(from -> containingToNodes.forEach(to -> this.internalGraph.edgeConnecting(from, to).ifPresent(containingEdges::add)));
        return containingEdges;
    }

    private Stream<Node> containingClassNodes(Node node) {
        return node.getType().isClassType() ? Stream.of(node) : this.internalGraph.outEdges((Object)node).stream().filter(Edge::isContaining).map(Edge::getTo).flatMap(this::containingClassNodes);
    }
}

