/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.report;

import j2html.tags.InlineStaticResource;
import j2html.utils.CSSMin;
import j2html.utils.JSMin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import org.webjars.WebJarAssetLocator;

public class ResourcesExtractor {
    private static final WebJarAssetLocator locator = new WebJarAssetLocator();

    public static void copyResources(File targetDir) throws IOException {
        targetDir.mkdirs();
        ResourcesExtractor.copyLocalResource(targetDir, "custom.css");
        ResourcesExtractor.copyLocalResource(targetDir, "custom.js");
        ResourcesExtractor.copyWebJarResource(targetDir, "bootstrap", "bootstrap.min.css");
        ResourcesExtractor.copyWebJarResource(targetDir, "bootstrap-icons", "bootstrap-icons.css");
        ResourcesExtractor.copyWebJarResource(targetDir, "bootstrap-icons", "fonts/bootstrap-icons.woff");
        ResourcesExtractor.copyWebJarResource(targetDir, "bootstrap-icons", "fonts/bootstrap-icons.woff2");
        ResourcesExtractor.copyWebJarResource(targetDir, "jquery", "jquery.min.js");
        ResourcesExtractor.copyWebJarResource(targetDir, "tooltipster", "tooltipster.bundle.min.js");
        ResourcesExtractor.copyWebJarResource(targetDir, "tooltipster", "tooltipster.bundle.min.css");
        ResourcesExtractor.copyWebJarResource(targetDir, "tooltipster", "tooltipster-SVG.min.js");
        ResourcesExtractor.copyWebJarResource(targetDir, "svg.js", "svg.min.js");
    }

    private static void copyLocalResource(File targetDir, String name) throws IOException {
        String content = InlineStaticResource.getFileAsString((String)("/report/" + name));
        if (name.endsWith(".css")) {
            content = CSSMin.compressCss((String)content);
        } else if (name.endsWith(".js")) {
            content = JSMin.compressJs((String)content);
        }
        File targetFile = ResourcesExtractor.getTargetFile(targetDir, name);
        Files.writeString(targetFile.toPath(), (CharSequence)content, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private static void copyWebJarResource(File targetDir, String webjar, String file) throws IOException {
        String fullPath = locator.getFullPath(webjar, file);
        InputStream inputStream = locator.getClass().getClassLoader().getResourceAsStream(fullPath);
        Objects.requireNonNull(inputStream, () -> String.format("Cannot read resource %s", fullPath));
        File targetFile = ResourcesExtractor.getTargetFile(targetDir, file);
        Files.copy(inputStream, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private static File getTargetFile(File targetDir, String name) {
        File targetFile = new File(targetDir, name);
        if (name.contains("/")) {
            targetFile.getParentFile().mkdirs();
        }
        return targetFile;
    }
}

