/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.slicer;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class PatternMatcher {
    private static final String SINGLE_STAR_PLACEHOLDER = "+";
    private static final String DOUBLE_STAR_PLACEHOLDER = "-";
    private static final String ALLOWED_SYMBOLS = ".*|(){}";
    private static final Set<Integer> ALLOWED_SYMBOL_CHARS = ".*|(){}".chars().boxed().collect(Collectors.toUnmodifiableSet());
    private static final Map<Character, Character> PAREN_PAIRS = Map.of(Character.valueOf('}'), Character.valueOf('{'), Character.valueOf(')'), Character.valueOf('('));
    private final Pattern pattern;
    private final int group;

    private static void validatePattern(String p, boolean grouping) {
        Preconditions.checkArgument((p != null ? 1 : 0) != 0, (Object)"Pattern string must not be null");
        PatternMatcher.validatePatternCharacters(p);
        PatternMatcher.validatePatternParentheses(p, grouping);
    }

    private static void validatePatternCharacters(String p) {
        p.chars().forEach(c -> PatternMatcher.validatePatternCharacter(c, p));
        if (p.contains("***")) {
            throw new IllegalArgumentException(String.format("More than two '*'s in a row is not a supported pattern - encountered '%s'", p));
        }
    }

    private static void validatePatternCharacter(int c, String p) {
        if (!Character.isJavaIdentifierPart(c) && !ALLOWED_SYMBOL_CHARS.contains(c)) {
            throw new IllegalArgumentException(String.format("Pattern string may contain only characters, digits, and '%s' - encountered '%c' in pattern '%s'", ALLOWED_SYMBOLS, c, p));
        }
    }

    private static void validatePatternParentheses(String p, boolean grouping) {
        int groupCount = 0;
        ArrayDeque<Character> parens = new ArrayDeque<Character>();
        block5: for (char c : p.toCharArray()) {
            switch (c) {
                case '{': {
                    ++groupCount;
                    parens.push(Character.valueOf(c));
                    continue block5;
                }
                case '(': {
                    parens.push(Character.valueOf(c));
                    continue block5;
                }
                case ')': 
                case '}': {
                    if (PAREN_PAIRS.get(Character.valueOf(c)).equals(parens.poll())) continue block5;
                    throw new IllegalArgumentException(String.format("Unmatched right parenthesis '%c' found in pattern '%s'", Character.valueOf(c), p));
                }
            }
        }
        if (!parens.isEmpty()) {
            throw new IllegalArgumentException(String.format("Unmatched left parenthesis '%c' found in pattern '%s'", parens.poll(), p));
        }
        if (grouping && groupCount > 1) {
            throw new IllegalArgumentException(String.format("More than one pair of curly braces are not allowed in the pattern '%s'", p));
        }
        if (!grouping && groupCount > 0) {
            throw new IllegalArgumentException(String.format("Curly braces are only allowed in slicing patterns. Encountered '%s'", p));
        }
    }

    public PatternMatcher(String p) {
        this(p, false);
    }

    public PatternMatcher(String p, boolean grouping) {
        PatternMatcher.validatePattern(p, grouping);
        this.group = PatternMatcher.determineGroup(p);
        this.pattern = Pattern.compile(PatternMatcher.replaceGroupingParens(PatternMatcher.escapeStars(PatternMatcher.escapeLiterals(p))));
    }

    public Optional<String> matches(String name) {
        Matcher matcher = this.pattern.matcher(name);
        return matcher.matches() ? Optional.of(matcher.group(this.group)) : Optional.empty();
    }

    private static String escapeStars(String p) {
        return p.replace("**", DOUBLE_STAR_PLACEHOLDER).replace("*", SINGLE_STAR_PLACEHOLDER).replace(DOUBLE_STAR_PLACEHOLDER, ".*").replace(SINGLE_STAR_PLACEHOLDER, "[^.]*");
    }

    private static String escapeLiterals(String p) {
        return p.replace(".", "\\.").replace("$", "\\$");
    }

    private static String replaceGroupingParens(String p) {
        return p.replace('{', '(').replace('}', ')');
    }

    private static int determineGroup(String p) {
        int group = 0;
        block4: for (int i = 0; i < p.length(); ++i) {
            switch (p.charAt(i)) {
                case '(': {
                    ++group;
                    continue block4;
                }
                case '{': {
                    return ++group;
                }
            }
        }
        return 0;
    }
}

