/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.analysis;

import de.obqo.decycle.analysis.GraphBuilder;
import de.obqo.decycle.analysis.GraphBuildingAnnotationVisitor;
import de.obqo.decycle.analysis.GraphBuildingFieldVisitor;
import de.obqo.decycle.analysis.GraphBuildingMethodVisitor;
import de.obqo.decycle.graph.Graph;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.TypePath;

public class GraphBuildingClassVisitor
extends ClassVisitor {
    private final GraphBuilder graphBuilder;

    GraphBuildingClassVisitor(Graph graph) {
        super(589824);
        this.graphBuilder = new GraphBuilder(graph);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.graphBuilder.visitCurrentClass(name);
        this.graphBuilder.connectNodesFromDescriptors(signature);
        if (superName != null) {
            this.graphBuilder.connect(GraphBuilder.classNodeFromTypeName(superName));
        }
        for (String i : interfaces) {
            this.graphBuilder.connect(GraphBuilder.classNodeFromTypeName(i));
        }
    }

    public void visitOuterClass(String owner, String name, String descriptor) {
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        this.graphBuilder.connectNodesFromDescriptors(descriptor);
        return new GraphBuildingAnnotationVisitor(this.api, this.graphBuilder);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        this.graphBuilder.connectNodesFromDescriptors(descriptor);
        return new GraphBuildingAnnotationVisitor(this.api, this.graphBuilder);
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        this.graphBuilder.connectNodesFromDescriptors(descriptor, signature);
        return new GraphBuildingFieldVisitor(this.api, this.graphBuilder);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        this.graphBuilder.connectNodesFromDescriptors(descriptor, signature);
        if (exceptions != null) {
            for (String e : exceptions) {
                this.graphBuilder.connect(GraphBuilder.classNodeFromTypeName(e));
            }
        }
        return new GraphBuildingMethodVisitor(this.api, this.graphBuilder);
    }
}

