/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.graph;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import de.obqo.decycle.graph.MutableSlicing;
import de.obqo.decycle.graph.Slicing;
import de.obqo.decycle.graph.SlicingSource;
import de.obqo.decycle.model.Edge;
import de.obqo.decycle.model.EdgeFilter;
import de.obqo.decycle.model.Node;
import de.obqo.decycle.model.NodeFilter;
import de.obqo.decycle.model.SliceType;
import de.obqo.decycle.slicer.Categorizer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Graph
implements SlicingSource {
    private final Categorizer categorizer;
    private final NodeFilter filter;
    private final EdgeFilter ignoredEdgesFilter;
    private final MutableNetwork<Node, Edge> internalGraph = NetworkBuilder.directed().build();
    private final Map<SliceType, Slicing> slicingCache = new HashMap<SliceType, Slicing>();

    public Graph() {
        this(null);
    }

    public Graph(Categorizer categorizer) {
        this(categorizer, null);
    }

    public Graph(Categorizer categorizer, NodeFilter filter) {
        this(categorizer, filter, null);
    }

    public Graph(Categorizer categorizer, NodeFilter filter, EdgeFilter ignoredEdgesFilter) {
        this.categorizer = Objects.requireNonNullElse(categorizer, Categorizer.EMPTY);
        this.filter = Objects.requireNonNullElse(filter, NodeFilter.ALL);
        this.ignoredEdgesFilter = Objects.requireNonNullElse(ignoredEdgesFilter, EdgeFilter.NONE);
    }

    public void connect(Node a, Node b) {
        this.addReference(a, b);
    }

    private void addReference(Node a, Node b) {
        if (this.filter.test(a) && this.filter.test(b) && !Objects.equals(a, b)) {
            boolean ignored = this.ignoredEdgesFilter.test(a, b);
            this.internalGraph.addEdge((Object)a, (Object)b, (Object)Edge.references(a, b, ignored));
        }
    }

    public void add(Node node) {
        if (this.filter.test(node)) {
            this.internalGraph.addNode((Object)node);
            Set categories = (Set)this.categorizer.apply(node);
            categories.forEach(category -> this.internalGraph.addEdge(category, (Object)node, (Object)Edge.contains(category, node)));
        }
    }

    @VisibleForTesting
    public Set<Node> allNodes() {
        return this.internalGraph.nodes();
    }

    @VisibleForTesting
    public Set<Node> contentsOf(Node group) {
        return this.connectedNodes(group, Edge.EdgeLabel.CONTAINS);
    }

    @VisibleForTesting
    public Set<Node> connectionsOf(Node node) {
        return this.connectedNodes(node, Edge.EdgeLabel.REFERENCES);
    }

    private Set<Node> connectedNodes(Node node, Edge.EdgeLabel label) {
        return this.outEdges(node).stream().filter(e -> e.getLabel() == label).map(Edge::getTo).collect(Collectors.toSet());
    }

    private Set<Edge> outEdges(Node node) {
        return this.internalGraph.nodes().contains(node) ? this.internalGraph.outEdges((Object)node) : Set.of();
    }

    private Set<Edge> inEdges(Node node) {
        return this.internalGraph.nodes().contains(node) ? this.internalGraph.inEdges((Object)node) : Set.of();
    }

    @Override
    public Set<SliceType> sliceTypes() {
        return this.internalGraph.nodes().stream().map(Node::getType).collect(Collectors.toSet());
    }

    @Override
    public Slicing slicing(SliceType sliceType) {
        return this.slicingCache.computeIfAbsent(sliceType, this::computeSlicing);
    }

    private Slicing computeSlicing(SliceType sliceType) {
        MutableSlicing slicing = MutableSlicing.create(sliceType);
        this.internalGraph.nodes().stream().filter(n -> n.hasType(sliceType)).forEach(slicing::addNode);
        this.internalGraph.edges().stream().filter(Edge::isReferencing).forEach(edge -> this.findSliceNode(edge.getFrom(), sliceType).ifPresent(from -> this.findSliceNode(edge.getTo(), sliceType).filter(Predicate.not(from::equals)).ifPresent(to -> slicing.edgeConnecting((Node)from, (Node)to).ifPresentOrElse(slideEdge -> slideEdge.combine((Edge)edge), () -> slicing.addEdge(Edge.references(from, to, edge.isIgnored()))))));
        return slicing;
    }

    private Optional<Node> findSliceNode(Node node, SliceType sliceType) {
        return this.findSliceNodes(node, sliceType).findFirst();
    }

    private Stream<Node> findSliceNodes(Node node, SliceType sliceType) {
        return node.hasType(sliceType) ? Stream.of(node) : this.inEdges(node).stream().filter(Edge::isContaining).map(Edge::getFrom).flatMap(from -> this.findSliceNodes((Node)from, sliceType));
    }

    public Set<Edge> containingClassEdges(Edge edge) {
        if (!edge.isReferencing()) {
            return Set.of();
        }
        Stream<Node> containingFromNodes = this.containingClassNodes(edge.getFrom());
        Set containingToNodes = this.containingClassNodes(edge.getTo()).collect(Collectors.toSet());
        HashSet<Edge> containingEdges = new HashSet<Edge>();
        containingFromNodes.forEach(from -> containingToNodes.forEach(to -> this.internalGraph.edgeConnecting(from, to).ifPresent(containingEdges::add)));
        return containingEdges;
    }

    private Stream<Node> containingClassNodes(Node node) {
        return node.getType().isClassType() ? Stream.of(node) : this.outEdges(node).stream().filter(Edge::isContaining).map(Edge::getTo).flatMap(this::containingClassNodes);
    }
}

