/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.slicer;

import de.obqo.decycle.model.EdgeFilter;
import de.obqo.decycle.model.Node;
import de.obqo.decycle.slicer.IgnoredDependency;
import de.obqo.decycle.slicer.PatternMatchingEdgeFilter;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class IgnoredDependenciesFilter
implements EdgeFilter {
    private final Set<EdgeFilter> filters;

    public IgnoredDependenciesFilter(Collection<IgnoredDependency> ignoredDependencies) {
        this.filters = Optional.ofNullable(ignoredDependencies).stream().flatMap(Collection::stream).map(this::toFilter).collect(Collectors.toSet());
    }

    private PatternMatchingEdgeFilter toFilter(IgnoredDependency dep) {
        return new PatternMatchingEdgeFilter(dep.getFromPattern(), dep.getToPattern());
    }

    @Override
    public boolean test(Node node1, Node node2) {
        return this.filters.stream().anyMatch(filter -> filter.test(node1, node2));
    }
}

