/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.check;

import com.google.common.base.Preconditions;
import de.obqo.decycle.check.Constraint;
import de.obqo.decycle.graph.MutableSlicing;
import de.obqo.decycle.graph.Slicing;
import de.obqo.decycle.graph.SlicingSource;
import de.obqo.decycle.graph.StronglyConnectedComponentsFinder;
import de.obqo.decycle.model.Edge;
import de.obqo.decycle.model.SliceType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class CycleFree
implements Constraint {
    @Override
    public String getShortString() {
        return "cycle";
    }

    @Override
    public List<Constraint.Violation> violations(SlicingSource slicingSource) {
        ArrayList<MutableSlicing> violatingSubgraphs = new ArrayList<MutableSlicing>();
        for (SliceType sliceType : slicingSource.sliceTypes()) {
            if (sliceType.isClassType()) continue;
            for (Set<Edge> comp : StronglyConnectedComponentsFinder.findComponents(slicingSource.slicing(sliceType))) {
                MutableSlicing violatingSubgraph = MutableSlicing.create(sliceType, comp);
                this.identifyViolations(violatingSubgraph);
                violatingSubgraphs.add(violatingSubgraph);
            }
        }
        ArrayList<Constraint.Violation> violations = new ArrayList<Constraint.Violation>();
        boolean multiple = violatingSubgraphs.size() > 1;
        for (int i = 0; i < violatingSubgraphs.size(); ++i) {
            violations.add(new Constraint.Violation(multiple ? String.format("%s (%d)", this.getShortString(), i + 1) : this.getShortString(), (Slicing)violatingSubgraphs.get(i)));
        }
        return violations;
    }

    private void identifyViolations(Slicing subgraph) {
        Preconditions.checkState((!subgraph.edges().isEmpty() ? 1 : 0) != 0);
        subgraph.edges().stream().min(Comparator.comparing(Edge::getWeight).thenComparing(Edge::displayString)).ifPresent(Edge::setViolating);
        StronglyConnectedComponentsFinder.findComponents(subgraph).forEach(edges -> this.identifyViolations(MutableSlicing.create(subgraph.getSliceType(), edges)));
    }
}

