/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.check;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Layer {
    private final boolean denyDependenciesWithinLayer;
    private final Set<String> slices;

    public static Layer anyOf(String ... slices) {
        return new Layer(false, slices);
    }

    public static Layer oneOf(String ... slices) {
        return new Layer(true, slices);
    }

    private Layer(boolean denyDependenciesWithinLayer, String ... slices) {
        this.denyDependenciesWithinLayer = denyDependenciesWithinLayer;
        this.slices = new LinkedHashSet<String>(List.of(slices));
    }

    public boolean contains(String slice) {
        return this.slices.contains(slice);
    }

    public boolean denyDependenciesWithinLayer() {
        return this.denyDependenciesWithinLayer;
    }

    public String getShortString() {
        if (this.slices.size() == 1) {
            return this.slices.iterator().next();
        }
        return this.denyDependenciesWithinLayer ? this.slices.stream().collect(Collectors.joining(", ", "[", "]")) : this.slices.stream().collect(Collectors.joining(", ", "(", ")"));
    }

    public String toString() {
        return this.getShortString();
    }

    public Set<String> getSlices() {
        return this.slices;
    }
}

