/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.graph;

import de.obqo.decycle.graph.Slicing;
import de.obqo.decycle.model.Edge;
import de.obqo.decycle.model.Node;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class StronglyConnectedComponentsFinder {
    public static Set<Set<Edge>> findComponents(Slicing graph) {
        Set<Set<Node>> components = new TarjansAlgorithm(graph).getMultiNodeComponents();
        HashSet<Set<Edge>> result = new HashSet<Set<Edge>>();
        for (Set<Node> component : components) {
            HashSet edges = new HashSet();
            for (Node from : component) {
                for (Node to : component) {
                    graph.edgeConnecting(from, to).filter(Edge::isIncluded).ifPresent(edges::add);
                }
            }
            result.add(edges);
        }
        return result;
    }

    private StronglyConnectedComponentsFinder() {
    }

    private static class TarjansAlgorithm {
        private final Slicing graph;
        private final int nodeCount;
        private final Set<Node> marked = new HashSet<Node>();
        private final Map<Node, Integer> id = new HashMap<Node, Integer>();
        private final Map<Node, Integer> low = new HashMap<Node, Integer>();
        private int pre;
        private int count;
        private final Set<Set<Node>> multiNodeComponents;

        TarjansAlgorithm(Slicing graph) {
            this.graph = graph;
            Set<Node> nodes = graph.nodes();
            this.nodeCount = nodes.size();
            HashMap<Integer, Set> componentMap = new HashMap<Integer, Set>();
            for (Node node : nodes) {
                if (!this.marked.contains(node)) {
                    this.depthFirstSearch(node, new LinkedList<Node>());
                }
                Set componentNodes = componentMap.computeIfAbsent(this.id.get(node), HashSet::new);
                componentNodes.add(node);
            }
            this.multiNodeComponents = componentMap.values().stream().filter(set -> set.size() > 1).collect(Collectors.toUnmodifiableSet());
        }

        private void depthFirstSearch(Node node, Deque<Node> stack) {
            Node n;
            this.marked.add(node);
            int min = this.pre++;
            this.low.put(node, min);
            stack.push(node);
            for (Edge edge : this.graph.outEdges(node)) {
                if (!edge.isIncluded()) continue;
                Node next = edge.getTo();
                if (!this.marked.contains(next)) {
                    this.depthFirstSearch(next, stack);
                }
                min = Math.min(this.low.get(next), min);
            }
            if (min < this.low.get(node)) {
                this.low.put(node, min);
                return;
            }
            do {
                n = stack.pop();
                this.id.put(n, this.count);
                this.low.put(n, this.nodeCount);
            } while (!Objects.equals(n, node));
            ++this.count;
        }

        Set<Set<Node>> getMultiNodeComponents() {
            return this.multiNodeComponents;
        }
    }
}

