/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.report.svg;

import de.obqo.decycle.report.svg.NumberFormatter;

public class PathBuilder {
    private final StringBuilder path = new StringBuilder();

    public static PathBuilder from(double x, double y) {
        return new PathBuilder().absMoveTo(x, y);
    }

    private PathBuilder() {
    }

    public String toString() {
        return this.path.toString();
    }

    public PathBuilder absMoveTo(double x, double y) {
        return this.line('M', x, y);
    }

    public PathBuilder relMoveTo(double dx, double dy) {
        return this.line('m', dx, dy);
    }

    public PathBuilder close() {
        this.path.append('z');
        return this;
    }

    public PathBuilder absVerticalLineTo(double y) {
        return this.line('V', y);
    }

    public PathBuilder relVerticalLineTo(double dy) {
        return this.line('v', dy);
    }

    public PathBuilder absHorizontalLineTo(double x) {
        return this.line('H', x);
    }

    public PathBuilder relHorizontalLineTo(double dx) {
        return this.line('h', dx);
    }

    private PathBuilder line(char command, double arg) {
        this.path.append(command).append(NumberFormatter.formatNumber(arg));
        return this;
    }

    public PathBuilder absLineTo(double x, double y) {
        return this.line('L', x, y);
    }

    public PathBuilder relLineTo(double dx, double dy) {
        return this.line('l', dx, dy);
    }

    private PathBuilder line(char command, double x, double y) {
        this.path.append(command).append(NumberFormatter.formatNumber(x)).append(' ').append(NumberFormatter.formatNumber(y));
        return this;
    }

    public PathBuilder absArc(double rx, double ry, double angle, boolean largeArc, boolean clockwise, double x, double y) {
        return this.arc('A', rx, ry, angle, largeArc, clockwise, x, y);
    }

    public PathBuilder relArc(double rx, double ry, double angle, boolean largeArc, boolean clockwise, double dx, double dy) {
        return this.arc('a', rx, ry, angle, largeArc, clockwise, dx, dy);
    }

    private PathBuilder arc(char command, double rx, double ry, double angle, boolean largeArc, boolean clockwise, double x, double y) {
        this.path.append(command).append(NumberFormatter.formatNumber(rx)).append(' ').append(NumberFormatter.formatNumber(ry)).append(' ').append(NumberFormatter.formatNumber(angle)).append(' ').append(largeArc ? 1 : 0).append(' ').append(clockwise ? 1 : 0).append(' ').append(NumberFormatter.formatNumber(x)).append(' ').append(NumberFormatter.formatNumber(y));
        return this;
    }
}

