/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.configuration;

import de.obqo.decycle.configuration.Pattern;
import de.obqo.decycle.slicer.Categorizer;
import de.obqo.decycle.slicer.NamedPatternMatchingCategorizer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NamedPattern
implements Pattern {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NamedPattern.class);
    private final String pattern;
    private final String name;

    public NamedPattern(String pattern, String name) {
        if (name.contains("*") || name.contains(".")) {
            log.warn("Decycle: Looks like you use the pattern '{}' as the NAME of a NamedPattern. Please note that a named pattern has the form <pattern>=<name>.", (Object)name);
        }
        if (pattern.contains("{") || pattern.contains("}")) {
            throw new IllegalArgumentException(String.format("Curly braces are not allowed in a named pattern. Encountered '%s'", pattern));
        }
        this.name = name;
        this.pattern = pattern;
    }

    @Override
    public Categorizer toCategorizer(String sliceType) {
        return new NamedPatternMatchingCategorizer(sliceType, this.pattern, this.name);
    }

    public String toString() {
        return this.pattern + "=" + this.name;
    }
}

