/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.model;

import java.util.Comparator;
import lombok.Generated;

public final class SliceType
implements Comparable<SliceType> {
    private static final Comparator<SliceType> COMPARATOR = Comparator.comparing(SliceType::getKind).thenComparing(SliceType::getName);
    private static final SliceType CLASS_TYPE = new SliceType(Kind.CLASS, "Class");
    private static final SliceType PACKAGE_TYPE = new SliceType(Kind.PACKAGE, "Package");
    private final Kind kind;
    private final String name;

    public static SliceType classType() {
        return CLASS_TYPE;
    }

    public static SliceType packageType() {
        return PACKAGE_TYPE;
    }

    public static SliceType customType(String name) {
        return new SliceType(Kind.CUSTOM, name);
    }

    public boolean isClassType() {
        return this.kind == Kind.CLASS;
    }

    public boolean isSliceType() {
        return this.kind == Kind.CUSTOM;
    }

    public String displayString() {
        return this.name;
    }

    @Override
    public int compareTo(SliceType other) {
        return COMPARATOR.compare(this, other);
    }

    @Generated
    public Kind getKind() {
        return this.kind;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SliceType)) {
            return false;
        }
        SliceType other = (SliceType)o;
        Kind this$kind = this.getKind();
        Kind other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Kind $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SliceType(kind=" + this.getKind() + ", name=" + this.getName() + ")";
    }

    @Generated
    private SliceType(Kind kind, String name) {
        this.kind = kind;
        this.name = name;
    }

    static enum Kind {
        CLASS,
        PACKAGE,
        CUSTOM;

    }
}

