/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.report;

import j2html.tags.InlineStaticResource;
import j2html.utils.CSSMin;
import j2html.utils.JSMin;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webjars.MultipleMatchesException;
import org.webjars.WebJarAssetLocator;

public class ResourcesExtractor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourcesExtractor.class);
    private static final WebJarAssetLocator locator = new WebJarAssetLocator();

    public static String createResourcesIfRequired(File reportDir) throws IOException {
        String resourcesDirName = "resources-" + ResourcesExtractor.class.getPackage().getImplementationVersion();
        File resourcesDir = new File(reportDir, resourcesDirName);
        if (!resourcesDir.exists() && resourcesDir.mkdirs()) {
            ResourcesExtractor.copyResources(resourcesDir);
        }
        return resourcesDirName;
    }

    public static void copyResources(File targetDir) throws IOException {
        ResourcesExtractor.copyLocalResource(targetDir, "report", "custom.css");
        ResourcesExtractor.copyLocalResource(targetDir, "report", "custom.js");
        ResourcesExtractor.copyLocalResource(targetDir, "libs", "tooltipster.bundle.min.css");
        ResourcesExtractor.copyLocalResource(targetDir, "libs", "tooltipster.bundle.min.js");
        ResourcesExtractor.copyLocalResource(targetDir, "libs", "tooltipster-SVG.min.js");
        ResourcesExtractor.copyLocalResource(targetDir, "libs", "bootstrap.min.css");
        ResourcesExtractor.copyLocalResource(targetDir, "libs", "bootstrap.min.css.map");
        ResourcesExtractor.copyWebJarResource(targetDir, "bootstrap-icons", "bootstrap-icons.css");
        ResourcesExtractor.copyWebJarResource(targetDir, "bootstrap-icons", "fonts/bootstrap-icons.woff");
        ResourcesExtractor.copyWebJarResource(targetDir, "bootstrap-icons", "fonts/bootstrap-icons.woff2");
        ResourcesExtractor.copyWebJarResource(targetDir, "jquery", "jquery.min.js");
        ResourcesExtractor.copyWebJarResource(targetDir, "svg.js", "svg.min.js");
        ResourcesExtractor.copyWebJarResource(targetDir, "svg.js", "svg.min.js.map");
    }

    private static void copyLocalResource(File targetDir, String prefix, String name) throws IOException {
        String content = InlineStaticResource.getFileAsString((String)("/" + prefix + "/" + name));
        if (name.endsWith(".css")) {
            content = CSSMin.compressCss((String)content);
        } else if (name.endsWith(".js")) {
            content = JSMin.compressJs((String)content);
        }
        ResourcesExtractor.copy(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), targetDir, name);
    }

    private static void copyWebJarResource(File targetDir, String webjar, String asset) throws IOException {
        String fullPath = ResourcesExtractor.getFullPath(webjar, asset);
        InputStream inputStream = locator.getClass().getClassLoader().getResourceAsStream(fullPath);
        Objects.requireNonNull(inputStream, () -> String.format("Cannot read resource %s", fullPath));
        ResourcesExtractor.copy(inputStream, targetDir, asset);
    }

    private static String getFullPath(String webjar, String asset) {
        try {
            return locator.getFullPath(webjar, asset);
        }
        catch (MultipleMatchesException ex) {
            log.info("Decycle: Found multiple {} versions: {}", (Object)asset, (Object)ex.getMatches());
            String path = ex.getMatches().stream().flatMap(match -> Optional.ofNullable(WebJarAssetLocator.getWebJar((CharSequence)match)).map(Map.Entry::getValue).map(version -> new AbstractMap.SimpleEntry<ComparableVersion, String>(new ComparableVersion(version), (String)match)).stream()).max(Map.Entry.comparingByKey()).map(Map.Entry::getValue).orElseGet(() -> (String)ex.getMatches().get(0));
            log.info("Decycle: use {}", (Object)path);
            return path;
        }
    }

    private static void copy(InputStream inputStream, File targetDir, String name) throws IOException {
        File targetFile = new File(targetDir, name);
        if (name.contains("/")) {
            targetFile.getParentFile().mkdirs();
        }
        try {
            Files.copy(inputStream, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
    }
}

