/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.analysis;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.Generated;

class FileFinder {
    static Stream<File> find(String rootPath) {
        return FileFinder.singleDirFind(new File(rootPath));
    }

    private static Stream<File> singleDirFind(File root) {
        Function<String, File> toFile = name -> new File(root, (String)name);
        if (root.isDirectory()) {
            String[] filenames = root.list();
            Preconditions.checkNotNull((Object)filenames, (Object)"returned filenames must not be null");
            Stream<File> classFiles = Stream.of(filenames).filter(FileFinder::isClassFile).map(toFile);
            Stream<File> dirs = Stream.of(filenames).map(toFile).filter(File::isDirectory);
            Stream nestedClassFiles = dirs.flatMap(FileFinder::singleDirFind);
            return Stream.concat(classFiles, nestedClassFiles);
        }
        return Stream.of(root).filter(file -> FileFinder.isClassFile(file.getName()));
    }

    private static boolean isClassFile(String name) {
        return name.endsWith(".class") || name.endsWith(".jar");
    }

    @Generated
    private FileFinder() {
    }
}

