/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.model;

import de.obqo.decycle.model.SliceType;
import java.util.Comparator;
import lombok.Generated;
import lombok.NonNull;

public final class Node
implements Comparable<Node> {
    public static final Comparator<Node> COMPARATOR = Comparator.comparing(Node::getName);
    @NonNull
    private final SliceType type;
    @NonNull
    private final String name;

    public static Node classNode(String name) {
        return new Node(SliceType.classType(), name);
    }

    public static Node packageNode(String name) {
        return new Node(SliceType.packageType(), name);
    }

    public static Node sliceNode(String type, String name) {
        return Node.sliceNode(SliceType.customType(type), name);
    }

    public static Node sliceNode(SliceType type, String name) {
        return new Node(type, name);
    }

    public boolean hasType(SliceType type) {
        return type.equals(this.type);
    }

    public String displayString() {
        return this.name;
    }

    @Override
    public int compareTo(Node other) {
        return COMPARATOR.compare(this, other);
    }

    @NonNull
    @Generated
    public SliceType getType() {
        return this.type;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        Node other = (Node)o;
        SliceType this$type = this.getType();
        SliceType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SliceType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Node(type=" + String.valueOf(this.getType()) + ", name=" + this.getName() + ")";
    }

    @Generated
    private Node(@NonNull SliceType type, @NonNull String name) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.type = type;
        this.name = name;
    }
}

