/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.report;

import j2html.tags.InlineStaticResource;
import j2html.utils.CSSMin;
import j2html.utils.JSMin;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcesExtractor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourcesExtractor.class);

    public static String createResourcesIfRequired(File reportDir) throws IOException {
        String resourcesDirName = "resources-" + ResourcesExtractor.class.getPackage().getImplementationVersion();
        File resourcesDir = new File(reportDir, resourcesDirName);
        if (!resourcesDir.exists() && resourcesDir.mkdirs()) {
            ResourcesExtractor.copyResources(resourcesDir);
        }
        return resourcesDirName;
    }

    public static void copyResources(File targetDir) throws IOException {
        ResourcesExtractor.copyLocalResource(targetDir, "custom.css");
        ResourcesExtractor.copyLocalResource(targetDir, "custom.js");
        ResourcesExtractor.copyLibResource(targetDir, "bootstrap.min.css");
        ResourcesExtractor.copyLibResource(targetDir, "bootstrap.min.css.map");
        ResourcesExtractor.copyLibResource(targetDir, "bootstrap-icons.css");
        ResourcesExtractor.copyLibResource(targetDir, "fonts/bootstrap-icons.woff");
        ResourcesExtractor.copyLibResource(targetDir, "fonts/bootstrap-icons.woff2");
        ResourcesExtractor.copyLibResource(targetDir, "jquery.min.js");
        ResourcesExtractor.copyLibResource(targetDir, "tooltipster.bundle.min.css");
        ResourcesExtractor.copyLibResource(targetDir, "tooltipster.bundle.min.js");
        ResourcesExtractor.copyLibResource(targetDir, "tooltipster-SVG.min.js");
        ResourcesExtractor.copyLibResource(targetDir, "svg.min.js");
        ResourcesExtractor.copyLibResource(targetDir, "svg.min.js.map");
    }

    private static void copyLocalResource(File targetDir, String name) throws IOException {
        String content = InlineStaticResource.getFileAsString((String)("/report/" + name));
        if (name.endsWith(".css")) {
            content = CSSMin.compressCss((String)content);
        } else if (name.endsWith(".js")) {
            content = JSMin.compressJs((String)content);
        }
        ResourcesExtractor.copy(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), targetDir, name);
    }

    private static void copyLibResource(File targetDir, String name) throws IOException {
        ResourcesExtractor.copy(ResourcesExtractor.class.getResourceAsStream("/libs/" + name), targetDir, name);
    }

    private static void copy(InputStream inputStream, File targetDir, String name) throws IOException {
        File targetFile = new File(targetDir, name);
        if (name.contains("/")) {
            targetFile.getParentFile().mkdirs();
        }
        try {
            Files.copy(inputStream, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
    }
}

