/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.slicer;

import com.google.common.base.Preconditions;
import de.obqo.decycle.model.Node;
import de.obqo.decycle.slicer.Categorizer;
import java.util.Set;
import lombok.Generated;

public class MultiCategorizer
implements Categorizer {
    private final Categorizer[] categorizers;

    public static Categorizer combine(Categorizer ... categorizers) {
        Preconditions.checkNotNull((Object)categorizers, (Object)"Missing categorizers for combine");
        return new MultiCategorizer(categorizers);
    }

    @Override
    public Set<Node> apply(Node node) {
        for (Categorizer categorizer : this.categorizers) {
            Set category = (Set)categorizer.apply(node);
            if (category.isEmpty()) continue;
            return category;
        }
        return NONE;
    }

    @Generated
    private MultiCategorizer(Categorizer[] categorizers) {
        this.categorizers = categorizers;
    }
}

