/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.slicer;

import com.google.common.base.Preconditions;
import de.obqo.decycle.model.Node;
import de.obqo.decycle.slicer.Categorizer;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class ParallelCategorizer
implements Categorizer {
    private final Categorizer[] categorizers;

    public static ParallelCategorizer parallel(Categorizer ... categorizers) {
        Preconditions.checkNotNull((Object)categorizers, (Object)"Missing categorizers for ParallelCategorizer");
        return new ParallelCategorizer(categorizers);
    }

    @Override
    public Set<Node> apply(Node node) {
        return Stream.of(this.categorizers).flatMap(categorizer -> ((Set)categorizer.apply(node)).stream()).collect(Collectors.toSet());
    }

    @Generated
    private ParallelCategorizer(Categorizer[] categorizers) {
        this.categorizers = categorizers;
    }
}

