/*
 * Decompiled with CFR 0.152.
 */
package de.onecode.navigator.ksp;

import com.google.devtools.ksp.processing.CodeGenerator;
import com.google.devtools.ksp.processing.Dependencies;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.processing.SymbolProcessor;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSFile;
import com.google.devtools.ksp.symbol.KSVisitor;
import de.onecode.navigator.api.Destination;
import de.onecode.navigator.api.SubGraph;
import de.onecode.navigator.api.Top;
import de.onecode.navigator.ksp.GraphSymbolProcessor;
import de.onecode.navigator.ksp.descriptions.DestinationDescription;
import de.onecode.navigator.ksp.descriptions.GraphDescription;
import de.onecode.navigator.ksp.descriptions.SubGraphDescription;
import de.onecode.navigator.ksp.discovery.DestinationVisitor;
import de.onecode.navigator.ksp.discovery.GraphVisitor;
import de.onecode.navigator.ksp.generator.CodeGenerationKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u00020\u000b*\b\u0012\u0004\u0012\u00020\f0\u0006H\u0002J\u0012\u0010\r\u001a\u00020\u000b*\b\u0012\u0004\u0012\u00020\f0\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/onecode/navigator/ksp/GraphSymbolProcessor;", "Lcom/google/devtools/ksp/processing/SymbolProcessor;", "codeGenerator", "Lcom/google/devtools/ksp/processing/CodeGenerator;", "(Lcom/google/devtools/ksp/processing/CodeGenerator;)V", "process", "", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "assertNoTopDestinationsPresent", "", "Lde/onecode/navigator/ksp/descriptions/DestinationDescription;", "assertOneHome", "compose-navigator-ksp"})
@SourceDebugExtension(value={"SMAP\nGraphSymbolProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphSymbolProcessor.kt\nde/onecode/navigator/ksp/GraphSymbolProcessor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,73:1\n1295#2,2:74\n1295#2,2:76\n1855#3,2:78\n766#3:82\n857#3,2:83\n1747#3,3:85\n37#4,2:80\n*S KotlinDebug\n*F\n+ 1 GraphSymbolProcessor.kt\nde/onecode/navigator/ksp/GraphSymbolProcessor\n*L\n27#1:74,2\n35#1:76,2\n41#1:78,2\n57#1:82\n57#1:83,2\n68#1:85,3\n50#1:80,2\n*E\n"})
public final class GraphSymbolProcessor
implements SymbolProcessor {
    @NotNull
    private final CodeGenerator codeGenerator;

    public GraphSymbolProcessor(@NotNull CodeGenerator codeGenerator) {
        Intrinsics.checkNotNullParameter((Object)codeGenerator, (String)"codeGenerator");
        this.codeGenerator = codeGenerator;
    }

    @NotNull
    public List<KSAnnotated> process(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        String string = Destination.class.getCanonicalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Destination::class.java.canonicalName");
        Sequence destinationSymbols = Resolver.getSymbolsWithAnnotation$default((Resolver)resolver, (String)string, (boolean)false, (int)2, null);
        if (!destinationSymbols.iterator().hasNext()) {
            return CollectionsKt.emptyList();
        }
        DestinationVisitor destinationVisitor = new DestinationVisitor();
        Sequence $this$forEach$iv = destinationSymbols;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KSAnnotated it = (KSAnnotated)element$iv;
            boolean bl = false;
            it.accept((KSVisitor)destinationVisitor, (Object)Unit.INSTANCE);
        }
        List<DestinationDescription> destinations = destinationVisitor.getDestinations();
        String string2 = SubGraph.class.getCanonicalName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SubGraph::class.java.canonicalName");
        Sequence subGraphSymbols = Resolver.getSymbolsWithAnnotation$default((Resolver)resolver, (String)string2, (boolean)false, (int)2, null);
        GraphVisitor graphVisitor = new GraphVisitor(destinations);
        Sequence $this$forEach$iv2 = subGraphSymbols;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            KSAnnotated it = (KSAnnotated)element$iv;
            boolean bl = false;
            it.accept((KSVisitor)graphVisitor, (Object)Unit.INSTANCE);
        }
        GraphDescription graph = graphVisitor.getGraph();
        this.assertOneHome(graph.getDestinations());
        Iterable $this$forEach$iv3 = graph.getSubGraphs();
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv3) {
            List<DestinationDescription> list;
            SubGraphDescription subGraph = (SubGraphDescription)element$iv;
            boolean bl = false;
            List<DestinationDescription> $this$process_u24lambda_u243_u24lambda_u242 = list = subGraph.getDestinations();
            boolean bl2 = false;
            this.assertOneHome($this$process_u24lambda_u243_u24lambda_u242);
            this.assertNoTopDestinationsPresent($this$process_u24lambda_u243_u24lambda_u242);
        }
        Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)resolver.getAllFiles());
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        KSFile[] kSFileArray = thisCollection$iv.toArray(new KSFile[0]);
        CodeGenerationKt.generateCode(this.codeGenerator, graph, new Dependencies(false, Arrays.copyOf(kSFileArray, kSFileArray.length)));
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private final void assertOneHome(List<DestinationDescription> $this$assertOneHome) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$assertOneHome;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DestinationDescription it = (DestinationDescription)element$iv$iv;
            boolean bl = false;
            if (!it.isHome()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List home = (List)destination$iv$iv;
        int homeAmount = home.size();
        if (homeAmount > 1) {
            String homeNames2 = CollectionsKt.joinToString$default((Iterable)home, null, null, null, (int)0, null, (Function1)assertOneHome.homeNames.1.INSTANCE, (int)31, null);
            throw new IllegalStateException(("Only one " + Reflection.getOrCreateKotlinClass(Destination.class).getSimpleName() + " is allowed to be marked as home within a graph or sub graph. Found " + home.size() + ": " + homeNames2).toString());
        }
        if (homeAmount == 0 && !((Collection)$this$assertOneHome).isEmpty()) {
            throw new IllegalStateException(("No " + Reflection.getOrCreateKotlinClass(Destination.class).getSimpleName() + " was marked as home").toString());
        }
    }

    private final void assertNoTopDestinationsPresent(List<DestinationDescription> $this$assertNoTopDestinationsPresent) {
        boolean hasTopDestinations;
        block4: {
            boolean bl;
            Iterable $this$any$iv = $this$assertNoTopDestinationsPresent;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DestinationDescription it = (DestinationDescription)element$iv;
                    boolean bl2 = false;
                    if (!it.isTop()) continue;
                    bl = true;
                    break block4;
                }
                bl = hasTopDestinations = false;
            }
        }
        if (hasTopDestinations) {
            throw new IllegalStateException((Reflection.getOrCreateKotlinClass(Top.class).getSimpleName() + " destinations are not supported in sub graphs").toString());
        }
    }
}

