/*
 * Decompiled with CFR 0.152.
 */
package ontologizer.io.annotation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import ontologizer.association.Association;
import ontologizer.association.AssociationContainer;
import ontologizer.io.annotation.AssociationParser;
import ontologizer.io.annotation.IAssociationParserProgress;
import ontologizer.io.obo.IParserInput;
import ontologizer.io.obo.OBOParser;
import ontologizer.io.obo.OBOParserException;
import ontologizer.io.obo.OBOParserFileInput;
import ontologizer.ontology.TermContainer;
import ontologizer.ontology.TermMap;
import ontologizer.types.ByteString;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class AssociationParserTest {
    private static final String OBO_FILE = AssociationParserTest.class.getClassLoader().getResource("gene_ontology.1_2.obo.gz").getPath();
    private static final String ASSOCIATION_FILE = AssociationParserTest.class.getClassLoader().getResource("gene_association.sgd.gz").getPath();
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    @Test
    public void testSimple() throws IOException, OBOParserException {
        int nAnnotatedGenes = 6359;
        int nAssociations = 87599;
        int nSynonyms = 9250;
        int nDBObjects = 6359;
        String[] someGenes = new String[]{"SRL1", "DDR2", "UFO1"};
        int[] someGeneTermCounts = new int[]{11, 4, 8};
        OBOParser oboParser = new OBOParser((IParserInput)new OBOParserFileInput(OBO_FILE));
        oboParser.doParse();
        AssociationParser ap = new AssociationParser((IParserInput)new OBOParserFileInput(ASSOCIATION_FILE), (TermMap)new TermContainer((Iterable)oboParser.getTermMap(), ByteString.EMPTY, ByteString.EMPTY));
        Assert.assertEquals((Object)ap.getFileType(), (Object)AssociationParser.Type.GAF);
        Assert.assertEquals((long)87599L, (long)ap.getAssociations().size());
        Association a = (Association)ap.getAssociations().get(0);
        Assert.assertEquals((Object)"S000007287", (Object)a.getDB_Object().toString());
        a = (Association)ap.getAssociations().get(49088);
        Assert.assertEquals((Object)"S000004009", (Object)a.getDB_Object().toString());
        AssociationContainer ac = new AssociationContainer((List)ap.getAssociations(), ap.getAnnotationMapping());
        Assert.assertEquals((String)"number of parsed associations", (long)nAssociations, (long)ap.getAssociations().size());
        Assert.assertEquals((String)"number of parsed synonyms", (long)nSynonyms, (long)ap.getAnnotationMapping().getNumberOfSynonyms());
        Assert.assertEquals((String)"number of parsed DB objects", (long)nDBObjects, (long)ap.getAnnotationMapping().getSymbols().length);
        Assert.assertEquals((String)"number of annotated genes", (long)nAnnotatedGenes, (long)ac.getAllAnnotatedGenes().size());
        for (int i = 0; i < someGenes.length; ++i) {
            Assert.assertEquals((long)ac.get(ByteString.b((String)someGenes[i])).getAssociations().size(), (long)someGeneTermCounts[i]);
        }
    }

    @Test
    public void testUncompressed() throws IOException, OBOParserException {
        int read;
        File assocFile = this.tmpFolder.newFile();
        GZIPInputStream in = new GZIPInputStream(new FileInputStream(ASSOCIATION_FILE));
        FileOutputStream out = new FileOutputStream(assocFile);
        byte[] buf = new byte[4096];
        while ((read = in.read(buf)) > 0) {
            out.write(buf, 0, read);
        }
        in.close();
        out.close();
        OBOParser oboParser = new OBOParser((IParserInput)new OBOParserFileInput(OBO_FILE));
        oboParser.doParse();
        AssociationParser ap = new AssociationParser((IParserInput)new OBOParserFileInput(assocFile.getAbsolutePath()), (TermMap)new TermContainer((Iterable)oboParser.getTermMap(), ByteString.EMPTY, ByteString.EMPTY));
        Assert.assertEquals((Object)ap.getFileType(), (Object)AssociationParser.Type.GAF);
        Assert.assertEquals((long)87599L, (long)ap.getAssociations().size());
        Association a = (Association)ap.getAssociations().get(0);
        Assert.assertEquals((Object)"S000007287", (Object)a.getDB_Object().toString());
        a = (Association)ap.getAssociations().get(49088);
        Assert.assertEquals((Object)"S000004009", (Object)a.getDB_Object().toString());
    }

    @Test
    public void testSkipHeader() throws IOException, OBOParserException {
        File tmp = this.tmpFolder.newFile("testSkipHeaeder.gaf");
        BufferedWriter bw = new BufferedWriter(new FileWriter(tmp));
        bw.write("# Comment1\n");
        bw.write("DB\tDBOBJID2\tSYMBOL\t\tGO:0005760\tPMID:00000\tEVIDENCE\t\tC\t\tgene\ttaxon:4932\t20121212\tSBA\n");
        bw.flush();
        bw.close();
        OBOParser oboParser = new OBOParser((IParserInput)new OBOParserFileInput(OBO_FILE));
        oboParser.doParse();
        AssociationParser ap = new AssociationParser((IParserInput)new OBOParserFileInput(tmp.getAbsolutePath()), (TermMap)new TermContainer((Iterable)oboParser.getTermMap(), ByteString.EMPTY, ByteString.EMPTY));
        AssociationContainer assoc = new AssociationContainer((List)ap.getAssociations(), ap.getAnnotationMapping());
        Assert.assertEquals((long)1L, (long)assoc.getAllAnnotatedGenes().size());
    }

    @Test
    public void testReadFromCompressedFile() throws IOException, OBOParserException {
        File tmp = this.tmpFolder.newFile("testReadFromCompressedFile.gaf.gz");
        OutputStreamWriter bw = new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(tmp)));
        bw.write("DB\tDBOBJID2\tSYMBOL\t\tGO:0005760\tPMID:00000\tEVIDENCE\t\tC\t\tgene\ttaxon:4932\t20121212\tSBA\n");
        ((Writer)bw).flush();
        ((Writer)bw).close();
        OBOParser oboParser = new OBOParser((IParserInput)new OBOParserFileInput(OBO_FILE));
        oboParser.doParse();
        AssociationParser ap = new AssociationParser((IParserInput)new OBOParserFileInput(tmp.getAbsolutePath()), (TermMap)new TermContainer((Iterable)oboParser.getTermMap(), ByteString.EMPTY, ByteString.EMPTY));
        AssociationContainer assoc = new AssociationContainer((List)ap.getAssociations(), ap.getAnnotationMapping());
        Assert.assertEquals((long)1L, (long)assoc.getAllAnnotatedGenes().size());
    }

    @Test
    public void testAmbiguousGAFCaseA() throws IOException, OBOParserException {
        File tmp = this.tmpFolder.newFile("testAmbiguousGAFCaseA.gaf");
        BufferedWriter bw = new BufferedWriter(new FileWriter(tmp));
        bw.write("DB\tDBOBJID1\tSYMBOL\t\tGO:0005763\tPMID:00000\tEVIDENCE\t\tC\tSYNONYM1|SYNONYM2\tgene\ttaxon:4932\t20121212\tSBA\n");
        bw.write("DB\tDBOBJID2\tSYMBOL\t\tGO:0005760\tPMID:00000\tEVIDENCE\t\tC\t\tgene\ttaxon:4932\t20121212\tSBA\n");
        bw.flush();
        bw.close();
        OBOParser oboParser = new OBOParser((IParserInput)new OBOParserFileInput(OBO_FILE));
        oboParser.doParse();
        WarningCapture warningCapture = new WarningCapture();
        AssociationParser ap = new AssociationParser((IParserInput)new OBOParserFileInput(tmp.getAbsolutePath()), (TermMap)new TermContainer((Iterable)oboParser.getTermMap(), ByteString.EMPTY, ByteString.EMPTY), null, (IAssociationParserProgress)warningCapture);
        AssociationContainer assoc = new AssociationContainer((List)ap.getAssociations(), ap.getAnnotationMapping());
        Assert.assertEquals((long)1L, (long)assoc.getAllAnnotatedGenes().size());
        Assert.assertEquals((Object)"SYMBOL", (Object)((ByteString)assoc.getAllAnnotatedGenes().iterator().next()).toString());
        Assert.assertEquals((long)1L, (long)warningCapture.warnings.size());
        Assert.assertEquals((Object)true, (Object)assoc.isSynonym(new ByteString("DBOBJID2")));
    }

    @Test
    public void testTwoEntries() throws IOException, OBOParserException {
        File tmp = this.tmpFolder.newFile("testTwoEntries.gaf");
        BufferedWriter bw = new BufferedWriter(new FileWriter(tmp));
        bw.write("\n\n");
        bw.write("DB\tDBOBJID\tSYMBOL1\t\tGO:0005763\tPMID:00000\tEVIDENCE\t\tC\tSYNONYM1|SYNONYM2\tgene\ttaxon:4932\t20121212\tSBA\n");
        bw.write("DB\tDBOBJID2\tSYMBOL2\t\tGO:0005760\tPMID:00000\tEVIDENCE\t\tC\t\tgene\ttaxon:4932\t20121212\tSBA\n");
        bw.flush();
        bw.close();
        OBOParser oboParser = new OBOParser((IParserInput)new OBOParserFileInput(OBO_FILE));
        oboParser.doParse();
        AssociationParser ap = new AssociationParser((IParserInput)new OBOParserFileInput(tmp.getAbsolutePath()), (TermMap)new TermContainer((Iterable)oboParser.getTermMap(), ByteString.EMPTY, ByteString.EMPTY));
        AssociationContainer assoc = new AssociationContainer((List)ap.getAssociations(), ap.getAnnotationMapping());
        Assert.assertEquals((long)2L, (long)assoc.getAllAnnotatedGenes().size());
    }

    @Test
    public void testAmbiguousGAFCaseB() throws IOException, OBOParserException {
        File tmp = this.tmpFolder.newFile("testAmbiguousGAFCaseB.gaf");
        BufferedWriter bw = new BufferedWriter(new FileWriter(tmp));
        bw.write("DB\tDBOBJID\tSYMBOL1\t\tGO:0005763\tPMID:00000\tEVIDENCE\t\tC\tSYNONYM1|SYNONYM2\tgene\ttaxon:4932\t20121212\tSBA\n");
        bw.write("DB\tDBOBJID\tSYMBOL2\t\tGO:0005760\tPMID:00000\tEVIDENCE\t\tC\t\tgene\ttaxon:4932\t20121212\tSBA\n");
        bw.flush();
        bw.close();
        OBOParser oboParser = new OBOParser((IParserInput)new OBOParserFileInput(OBO_FILE));
        oboParser.doParse();
        WarningCapture warningCapture = new WarningCapture();
        AssociationParser ap = new AssociationParser((IParserInput)new OBOParserFileInput(tmp.getAbsolutePath()), (TermMap)new TermContainer((Iterable)oboParser.getTermMap(), ByteString.EMPTY, ByteString.EMPTY), null, (IAssociationParserProgress)warningCapture);
        AssociationContainer assoc = new AssociationContainer((List)ap.getAssociations(), ap.getAnnotationMapping());
        Assert.assertEquals((long)2L, (long)assoc.getAllAnnotatedGenes().size());
        Assert.assertEquals((long)1L, (long)warningCapture.warnings.size());
    }

    @Test
    public void testIDS() throws IOException, OBOParserException {
        File tmp = this.tmpFolder.newFile("testIDS.ids");
        BufferedWriter bw = new BufferedWriter(new FileWriter(tmp));
        bw.write("S000007287\tGO:0005763,GO:0032543,GO:0042255,GO:0003735,GO:0032543,GO:0005762,GO:0003735,GO:0003735,GO:0042255\n");
        bw.write("S000004660\tGO:0005739,GO:0006810,GO:0005743,GO:0016020,GO:0055085,GO:0005488\n");
        bw.write("S000004660\tGO:0006810,GO:0005471,GO:0016021,GO:0006783,GO:0005743,GO:0005743\n");
        bw.flush();
        bw.close();
        OBOParser oboParser = new OBOParser((IParserInput)new OBOParserFileInput(OBO_FILE));
        oboParser.doParse();
        AssociationParser ap = new AssociationParser((IParserInput)new OBOParserFileInput(tmp.getAbsolutePath()), (TermMap)new TermContainer((Iterable)oboParser.getTermMap(), ByteString.EMPTY, ByteString.EMPTY));
        Assert.assertEquals((long)21L, (long)ap.getAssociations().size());
    }

    public static class WarningCapture
    implements IAssociationParserProgress {
        public List<String> warnings = new ArrayList<String>();

        public void init(int max) {
        }

        public void update(int current) {
        }

        public void warning(String message) {
            this.warnings.add(message);
        }
    }
}

