/*
 * Decompiled with CFR 0.152.
 */
package ontologizer.io.linescanner;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import ontologizer.io.linescanner.AbstractByteLineScanner;
import ontologizer.io.obo.OntologyTest;
import org.junit.Assert;
import org.junit.Test;

public class AbstractByteLineScannerTest {
    @Test
    public void testBigFile() throws FileNotFoundException, IOException {
        String oboPath = OntologyTest.class.getClassLoader().getResource("gene_ontology.1_2.obo.gz").getPath();
        GZIPInputStream is = new GZIPInputStream(new FileInputStream(oboPath));
        final BufferedReader br = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(oboPath))));
        class TestByteLineScanner
        extends AbstractByteLineScanner {
            public int actualLineCount;
            public int expectedLineCount;

            public TestByteLineScanner(InputStream is) {
                super(is);
            }

            public boolean newLine(byte[] buf, int start, int len) {
                String expectedString;
                ++this.actualLineCount;
                StringBuilder actualString = new StringBuilder();
                for (int i = start; i < start + len; ++i) {
                    actualString.append((char)buf[i]);
                }
                try {
                    expectedString = br.readLine();
                    ++this.expectedLineCount;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                Assert.assertEquals((Object)expectedString, (Object)actualString.toString());
                return true;
            }
        }
        TestByteLineScanner tbls = new TestByteLineScanner(is);
        tbls.scan();
        Assert.assertEquals((long)tbls.expectedLineCount, (long)tbls.actualLineCount);
        Assert.assertNull((Object)br.readLine());
        br.close();
    }

    @Test
    public void testMissingNewLineAtLineEnd() throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream("test\ntest2".getBytes());
        class TestByteLineScanner
        extends AbstractByteLineScanner {
            public int lines;

            public TestByteLineScanner(InputStream is) {
                super(is);
            }

            public boolean newLine(byte[] buf, int start, int len) {
                ++this.lines;
                return true;
            }
        }
        TestByteLineScanner tbls = new TestByteLineScanner(bais);
        tbls.scan();
        Assert.assertEquals((long)2L, (long)tbls.lines);
    }

    @Test
    public void testAvailable() throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream("test\ntest2\n\test3\n".getBytes());
        class TestByteLineScanner
        extends AbstractByteLineScanner {
            public TestByteLineScanner(InputStream is) {
                super(is);
            }

            public boolean newLine(byte[] buf, int start, int len) {
                return false;
            }
        }
        TestByteLineScanner tbls = new TestByteLineScanner(bais);
        tbls.scan();
        Assert.assertEquals((long)12L, (long)tbls.available());
        byte[] expected = "test2\n\test3\n".getBytes();
        byte[] actual = tbls.availableBuffer();
        Assert.assertEquals((long)12L, (long)expected.length);
        for (int i = 0; i < 12; ++i) {
            Assert.assertEquals((long)expected[i], (long)actual[i]);
        }
    }

    @Test
    public void testPush() throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream("test\ntest2".getBytes());
        class TestByteLineScanner
        extends AbstractByteLineScanner {
            public List<String> lines;

            public TestByteLineScanner(InputStream is) {
                super(is);
                this.lines = new ArrayList<String>();
            }

            public boolean newLine(byte[] buf, int start, int len) {
                this.lines.add(new String(buf, start, len));
                return true;
            }
        }
        TestByteLineScanner tbls = new TestByteLineScanner(bais);
        tbls.push("test-1\n\n".getBytes());
        tbls.scan();
        Assert.assertEquals((long)4L, (long)tbls.lines.size());
        Assert.assertEquals((Object)"test-1", (Object)tbls.lines.get(0));
        Assert.assertEquals((Object)"", (Object)tbls.lines.get(1));
        Assert.assertEquals((Object)"test", (Object)tbls.lines.get(2));
        Assert.assertEquals((Object)"test2", (Object)tbls.lines.get(3));
    }
}

