/*
 * Decompiled with CFR 0.152.
 */
package ontologizer.io.obo;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import ontologizer.io.obo.IParserInput;
import ontologizer.io.obo.OBOParser;
import ontologizer.io.obo.OBOParserException;
import ontologizer.io.obo.OBOParserFileInput;
import ontologizer.ontology.Term;
import ontologizer.ontology.TermID;
import ontologizer.ontology.TermRelation;
import ontologizer.types.ByteString;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class OBOParserTest {
    public static final String GOtermsOBOFile = OBOParserTest.class.getClassLoader().getResource("gene_ontology.1_2.obo.gz").getPath();
    private static final int nTermCount = 35520;
    private static final int nRelations = 63105;
    private static final ByteString formatVersion = ByteString.b((String)"1.2");
    private static final ByteString date = ByteString.b((String)"04:01:2012 11:50");
    private static final ByteString data_version = ByteString.b((String)"1.1.2476");
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    @Test
    public void testTermBasics() throws IOException, OBOParserException {
        System.out.println("Parse OBO file");
        OBOParser oboParser = new OBOParser((IParserInput)new OBOParserFileInput(GOtermsOBOFile));
        System.out.println(oboParser.doParse());
        HashMap<String, Term> id2Term = new HashMap<String, Term>();
        int relations = 0;
        for (Term t : oboParser.getTermMap()) {
            relations += t.getParents().length;
            id2Term.put(t.getIDAsString(), t);
        }
        Assert.assertEquals((long)35520L, (long)oboParser.getTermMap().size());
        Assert.assertEquals((Object)formatVersion, (Object)oboParser.getFormatVersion());
        Assert.assertEquals((Object)date, (Object)oboParser.getDate());
        Assert.assertEquals((Object)data_version, (Object)oboParser.getDataVersion());
        Assert.assertEquals((long)63105L, (long)relations);
        Assert.assertTrue((boolean)id2Term.containsKey("GO:0008150"));
        Assert.assertEquals((long)0L, (long)((Term)id2Term.get("GO:0008150")).getParents().length);
    }

    @Test
    public void testIgnoreSynonyms() throws IOException, OBOParserException {
        OBOParser oboParser = new OBOParser((IParserInput)new OBOParserFileInput(GOtermsOBOFile), 16);
        oboParser.doParse();
        for (Term t : oboParser.getTermMap()) {
            Assert.assertTrue((t.getSynonyms() == null || t.getSynonyms().length == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMultiline() throws IOException, OBOParserException {
        File tmp = File.createTempFile("onto", ".obo");
        PrintWriter pw = new PrintWriter(tmp);
        pw.append("[term]\nname: test\\\ntest\\\ntest\n");
        pw.close();
        OBOParser oboParser = new OBOParser((IParserInput)new OBOParserFileInput(tmp.getCanonicalPath()));
        oboParser.doParse();
    }

    @Test
    public void testPartOf() throws IOException, OBOParserException {
        File tmp = this.tmpFolder.newFile();
        PrintWriter pw = new PrintWriter(tmp);
        pw.append("[term]\nname: test\nid: GO:0000001\n\n[term]\nname: test2\nid: GO:0000002\n\nrelationship: part_of GO:0000001 ! test\n");
        pw.close();
        OBOParser oboParser = new OBOParser((IParserInput)new OBOParserFileInput(tmp.getCanonicalPath()));
        oboParser.doParse();
        ArrayList terms = new ArrayList(oboParser.getTermMap());
        HashMap<String, Term> name2Term = new HashMap<String, Term>();
        for (Term t : terms) {
            name2Term.put(t.getIDAsString(), t);
        }
        Assert.assertEquals((Object)TermRelation.PART_OF_A, (Object)((Term)name2Term.get((Object)"GO:0000002")).getParents()[0].relation);
        Assert.assertEquals((Object)"GO:0000001", (Object)((Term)name2Term.get((Object)"GO:0000002")).getParents()[0].termid.toString());
    }

    @Test
    public void testRegulates() throws IOException, OBOParserException {
        File tmp = this.tmpFolder.newFile();
        PrintWriter pw = new PrintWriter(tmp);
        pw.append("[term]\nname: test\nid: GO:0000001\n\n[term]\nname: test2\nid: GO:0000002\n\nrelationship: regulates GO:0000001 ! test\n");
        pw.close();
        OBOParser oboParser = new OBOParser((IParserInput)new OBOParserFileInput(tmp.getCanonicalPath()));
        oboParser.doParse();
        ArrayList terms = new ArrayList(oboParser.getTermMap());
        HashMap<String, Term> name2Term = new HashMap<String, Term>();
        for (Term t : terms) {
            name2Term.put(t.getIDAsString(), t);
        }
        Assert.assertEquals((Object)TermRelation.REGULATES, (Object)((Term)name2Term.get((Object)"GO:0000002")).getParents()[0].relation);
        Assert.assertEquals((Object)"GO:0000001", (Object)((Term)name2Term.get((Object)"GO:0000002")).getParents()[0].termid.toString());
    }

    @Test
    public void testUnknownRelationship() throws IOException, OBOParserException {
        File tmp = this.tmpFolder.newFile();
        PrintWriter pw = new PrintWriter(tmp);
        pw.append("[term]\nname: test\nid: GO:0000001\n\n[term]\nname: test2\nid: GO:0000002\n\nrelationship: zzz GO:0000001 ! test\n");
        pw.close();
        OBOParser oboParser = new OBOParser((IParserInput)new OBOParserFileInput(tmp.getCanonicalPath()));
        oboParser.doParse();
        ArrayList terms = new ArrayList(oboParser.getTermMap());
        HashMap<String, Term> name2Term = new HashMap<String, Term>();
        for (Term t : terms) {
            name2Term.put(t.getIDAsString(), t);
        }
        Assert.assertEquals((Object)TermRelation.UNKOWN, (Object)((Term)name2Term.get((Object)"GO:0000002")).getParents()[0].relation);
        Assert.assertEquals((Object)"GO:0000001", (Object)((Term)name2Term.get((Object)"GO:0000002")).getParents()[0].termid.toString());
    }

    @Test
    public void testSynonyms() throws IOException, OBOParserException {
        File tmp = this.tmpFolder.newFile();
        PrintWriter pw = new PrintWriter(tmp);
        pw.append("[term]\nname: test\nid: GO:0000001\nsynonym: \"test2\"\nsynonym: \"test3\" EXACT []\n");
        pw.close();
        OBOParser oboParser = new OBOParser((IParserInput)new OBOParserFileInput(tmp.getCanonicalPath()));
        oboParser.doParse();
        ArrayList terms = new ArrayList(oboParser.getTermMap());
        Assert.assertEquals((long)1L, (long)terms.size());
        String[] expected = new String[]{"test2", "test3"};
        Assert.assertEquals((long)expected.length, (long)((Term)terms.get(0)).getSynonyms().length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)((Term)terms.get(0)).getSynonyms()[i].toString());
        }
    }

    @Test
    public void testDef() throws IOException, OBOParserException {
        File tmp = this.tmpFolder.newFile();
        PrintWriter pw = new PrintWriter(tmp);
        pw.append("[term]\nname: test\nid: GO:0000001\ndef: \"This is a so-called \\\"test\\\"\"\n");
        pw.close();
        OBOParser oboParser = new OBOParser((IParserInput)new OBOParserFileInput(tmp.getCanonicalPath()), 1);
        oboParser.doParse();
        ArrayList terms = new ArrayList(oboParser.getTermMap());
        Assert.assertEquals((long)1L, (long)terms.size());
        Assert.assertEquals((Object)"This is a so-called \"test\"", (Object)((Term)terms.get(0)).getDefinition().toString());
    }

    @Test
    public void testEquivalent() throws IOException, OBOParserException {
        File tmp = this.tmpFolder.newFile();
        PrintWriter pw = new PrintWriter(tmp);
        pw.append("[term]\nname: test\nid: GO:0000001\ndef: \"This is a so-called \\\"test\\\"\"\n\n[term]\nname: test2\nid: GO:0000002\nequivalent_to: GO:0000001\nequivalent_to: GO:0000003 ! comment\n");
        pw.close();
        OBOParser oboParser = new OBOParser((IParserInput)new OBOParserFileInput(tmp.getCanonicalPath()));
        oboParser.doParse();
        ArrayList terms = new ArrayList(oboParser.getTermMap());
        HashMap<String, Term> name2Term = new HashMap<String, Term>();
        for (Term t : terms) {
            name2Term.put(t.getIDAsString(), t);
        }
        Assert.assertEquals((long)2L, (long)((Term)name2Term.get("GO:0000002")).getEquivalents().length);
        HashSet<String> ids = new HashSet<String>();
        ids.add("GO:0000001");
        ids.add("GO:0000003");
        for (TermID id : ((Term)name2Term.get("GO:0000002")).getEquivalents()) {
            Assert.assertTrue((boolean)ids.contains(id.toString()));
        }
    }

    @Test
    public void testObsolete() throws IOException, OBOParserException {
        File tmp = this.tmpFolder.newFile();
        PrintWriter pw = new PrintWriter(tmp);
        pw.append("[term]\nname: test\nid: GO:0000001\ndef: \"This is a so-called \\\"test\\\"\"\nis_obsolete: true");
        pw.close();
        OBOParser oboParser = new OBOParser((IParserInput)new OBOParserFileInput(tmp.getCanonicalPath()), 2);
        oboParser.doParse();
        ArrayList terms = new ArrayList(oboParser.getTermMap());
        Assert.assertTrue((boolean)((Term)terms.get(0)).isObsolete());
    }

    @Test
    public void testXRef() throws IOException, OBOParserException {
        File tmp = this.tmpFolder.newFile();
        PrintWriter pw = new PrintWriter(tmp);
        pw.append("[term]\nname: test\nid: GO:0000001\ndef: \"This is a so-called \\\"test\\\"\"\nxref: db:ID \"WW\"");
        pw.close();
        OBOParser oboParser = new OBOParser((IParserInput)new OBOParserFileInput(tmp.getCanonicalPath()), 2);
        oboParser.doParse();
        ArrayList terms = new ArrayList(oboParser.getTermMap());
        Assert.assertEquals((long)1L, (long)terms.size());
        Assert.assertEquals((Object)"db", (Object)((Term)terms.get(0)).getXrefs()[0].getDatabase());
        Assert.assertEquals((Object)"ID", (Object)((Term)terms.get(0)).getXrefs()[0].getXrefId());
        Assert.assertEquals((Object)"WW", (Object)((Term)terms.get(0)).getXrefs()[0].getXrefName());
    }

    @Test
    public void testXRef2Spaces() throws IOException, OBOParserException {
        File tmp = this.tmpFolder.newFile();
        PrintWriter pw = new PrintWriter(tmp);
        pw.append("[term]\nname: test\nid: GO:0000001\ndef: \"This is a so-called \\\"test\\\"\"\nxref: db:ID  \"WW\"");
        pw.close();
        OBOParser oboParser = new OBOParser((IParserInput)new OBOParserFileInput(tmp.getCanonicalPath()), 2);
        oboParser.doParse();
        ArrayList terms = new ArrayList(oboParser.getTermMap());
        Assert.assertEquals((long)1L, (long)terms.size());
        Assert.assertEquals((Object)"db", (Object)((Term)terms.get(0)).getXrefs()[0].getDatabase());
        Assert.assertEquals((Object)"ID", (Object)((Term)terms.get(0)).getXrefs()[0].getXrefId());
        Assert.assertEquals((Object)"WW", (Object)((Term)terms.get(0)).getXrefs()[0].getXrefName());
    }

    @Test
    public void testSimpleXRef() throws IOException, OBOParserException {
        File tmp = this.tmpFolder.newFile();
        PrintWriter pw = new PrintWriter(tmp);
        pw.append("[term]\nname: test\nid: GO:0000001\ndef: \"This is a so-called \\\"test\\\"\"\nxref: db:ID");
        pw.close();
        OBOParser oboParser = new OBOParser((IParserInput)new OBOParserFileInput(tmp.getCanonicalPath()), 2);
        oboParser.doParse();
        ArrayList terms = new ArrayList(oboParser.getTermMap());
        Assert.assertEquals((long)1L, (long)terms.size());
        Assert.assertEquals((Object)"db", (Object)((Term)terms.get(0)).getXrefs()[0].getDatabase());
        Assert.assertEquals((Object)"ID", (Object)((Term)terms.get(0)).getXrefs()[0].getXrefId());
        Assert.assertNull((Object)((Term)terms.get(0)).getXrefs()[0].getXrefName());
    }

    @Test
    public void testSubset() throws IOException, OBOParserException {
        File tmp = this.tmpFolder.newFile();
        PrintWriter pw = new PrintWriter(tmp);
        pw.append("subsetdef: subset \"Subset\"\n[term]\nname: test\nid: GO:0000001\nsubset: subset\n[term]\nname: test2\nid: GO:0000002\n");
        pw.close();
        OBOParser oboParser = new OBOParser((IParserInput)new OBOParserFileInput(tmp.getCanonicalPath()), 1);
        oboParser.doParse();
        ArrayList terms = new ArrayList(oboParser.getTermMap());
        Assert.assertEquals((long)2L, (long)terms.size());
        Assert.assertEquals((long)1L, (long)((Term)terms.get(0)).getSubsets().length);
        Assert.assertEquals((Object)"subset", (Object)((Term)terms.get(0)).getSubsets()[0].getName().toString());
        Assert.assertEquals((long)0L, (long)((Term)terms.get(1)).getSubsets().length);
    }

    @Test
    public void testAltId() throws IOException, OBOParserException {
        File tmp = this.tmpFolder.newFile();
        PrintWriter pw = new PrintWriter(tmp);
        pw.append("[term]\nname: test\nid: GO:0000001\nalt_id: GO:0000003\n");
        pw.close();
        OBOParser oboParser = new OBOParser((IParserInput)new OBOParserFileInput(tmp.getCanonicalPath()), 1);
        oboParser.doParse();
        ArrayList terms = new ArrayList(oboParser.getTermMap());
        Assert.assertEquals((long)1L, (long)terms.size());
        Assert.assertEquals((Object)"GO:0000003", (Object)((Term)terms.get(0)).getAlternatives()[0].toString());
    }

    @Test
    public void testExceptions() throws IOException {
        File tmp = this.tmpFolder.newFile();
        PrintWriter pw = new PrintWriter(tmp);
        pw.append("[term\nimport: sss\n");
        pw.close();
        OBOParser oboParser = new OBOParser((IParserInput)new OBOParserFileInput(tmp.getCanonicalPath()));
        try {
            oboParser.doParse();
            Assert.assertTrue((String)"Exception asserted", (boolean)false);
        }
        catch (OBOParserException ex) {
            ex.printStackTrace();
            Assert.assertEquals((long)1L, (long)ex.linenum);
        }
    }

    @Test
    public void testExceptions2() throws IOException {
        File tmp = this.tmpFolder.newFile();
        PrintWriter pw = new PrintWriter(tmp);
        pw.append("[term \nimport: sss\n");
        pw.close();
        OBOParser oboParser = new OBOParser((IParserInput)new OBOParserFileInput(tmp.getCanonicalPath()));
        try {
            oboParser.doParse();
            Assert.assertTrue((String)"Exception asserted", (boolean)false);
        }
        catch (OBOParserException ex) {
            ex.printStackTrace();
            Assert.assertEquals((long)1L, (long)ex.linenum);
        }
    }

    @Test
    public void testArbitraryID() throws IOException, OBOParserException {
        File tmp = this.tmpFolder.newFile();
        PrintWriter pw = new PrintWriter(tmp);
        pw.append("[term]\nname: test\nid: prefix:test\n");
        pw.close();
        OBOParser oboParser = new OBOParser((IParserInput)new OBOParserFileInput(tmp.getCanonicalPath()), 0);
        oboParser.doParse();
        ArrayList terms = new ArrayList(oboParser.getTermMap());
        Assert.assertEquals((long)1L, (long)terms.size());
    }
}

