/*
 * Decompiled with CFR 0.152.
 */
package ontologizer.io.obo;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import ontologizer.io.obo.IParserInput;
import ontologizer.io.obo.InternalOntology;
import ontologizer.io.obo.OBOParser;
import ontologizer.io.obo.OBOParserFileInput;
import ontologizer.ontology.Namespace;
import ontologizer.ontology.Ontology;
import ontologizer.ontology.Subset;
import ontologizer.ontology.Term;
import ontologizer.ontology.TermContainer;
import ontologizer.ontology.TermID;
import ontologizer.types.ByteString;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OntologyTest {
    private TermContainer goTerms;
    private Ontology graph;

    @Before
    public void setUp() throws Exception {
        String GOtermsOBOFile = OntologyTest.class.getClassLoader().getResource("gene_ontology.1_2.obo.gz").getPath();
        System.out.println("Parse OBO file");
        OBOParser oboParser = new OBOParser((IParserInput)new OBOParserFileInput(GOtermsOBOFile));
        System.out.println(oboParser.doParse());
        this.goTerms = new TermContainer((Iterable)oboParser.getTermMap(), oboParser.getFormatVersion(), oboParser.getDate());
        System.out.println("Build graph");
        this.graph = Ontology.create((TermContainer)this.goTerms);
    }

    @Test
    public void testRoot() {
        Set terms = this.graph.getTermChildrenAsStrings("GO:0000000");
        Assert.assertTrue((String)"Test we get some Set<String> object back", (terms != null ? 1 : 0) != 0);
        Assert.assertEquals((String)"Root has three descendants", (long)3L, (long)terms.size());
        terms = this.graph.getTermParentsAsStrings("GO:0000000");
        Assert.assertTrue((String)"Test we gat some Set<String> object back", (terms != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Root has no ancestors", (terms.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testExistsPath() {
        Assert.assertTrue((boolean)this.graph.existsPath(new TermID("GO:0009987"), new TermID("GO:0006281")));
        Assert.assertFalse((boolean)this.graph.existsPath(new TermID("GO:0006281"), new TermID("GO:0009987")));
        Assert.assertTrue((boolean)this.graph.existsPath(new TermID("GO:0008150"), new TermID("GO:0006281")));
        Assert.assertFalse((boolean)this.graph.existsPath(new TermID("GO:0006281"), new TermID("GO:0008150")));
        Assert.assertFalse((boolean)this.graph.existsPath(new TermID("GO:0006139"), new TermID("GO:0009719")));
        Assert.assertFalse((boolean)this.graph.existsPath(new TermID("GO:0009719"), new TermID("GO:0006139")));
    }

    @Test
    public void testWalkToRoot() {
        class VisitingGOVertex
        implements Ontology.IVisitingGOVertex {
            public int count = 0;

            VisitingGOVertex() {
            }

            public boolean visited(Term term) {
                ++this.count;
                System.out.println(term + " " + this.count);
                return true;
            }

            public void resetCount() {
                this.count = 0;
            }

            public int getCount() {
                return this.count;
            }
        }
        VisitingGOVertex vistingGOVertex = new VisitingGOVertex();
        this.graph.walkToSource(new TermID("GO:0008152"), (Ontology.IVisitingGOVertex)vistingGOVertex);
        Assert.assertEquals((long)3L, (long)vistingGOVertex.getCount());
        vistingGOVertex.resetCount();
        this.graph.walkToSource(new TermID("GO:0044237"), (Ontology.IVisitingGOVertex)vistingGOVertex);
        Assert.assertEquals((long)5L, (long)vistingGOVertex.getCount());
        vistingGOVertex.resetCount();
        this.graph.walkToSource(new TermID("GO:0006281"), (Ontology.IVisitingGOVertex)vistingGOVertex);
        Assert.assertEquals((long)19L, (long)vistingGOVertex.getCount());
    }

    private static Collection<TermID> newTermIDCollection(String ... ids) {
        HashSet<TermID> hs = new HashSet<TermID>();
        for (String id : ids) {
            hs.add(new TermID(id));
        }
        return hs;
    }

    @Test
    public void testGetSharedParentsSimple() {
        Term t = this.graph.getTerm("GO:0008152");
        Collection parents = this.graph.getSharedParents(t.getID(), t.getID());
        Assert.assertEquals((long)3L, (long)parents.size());
        Assert.assertTrue((boolean)parents.containsAll(OntologyTest.newTermIDCollection("GO:0008152", "GO:0008150", "GO:0000000")));
    }

    @Test
    public void testGetSharedParents() {
        Term t1 = this.graph.getTerm("GO:0008152");
        Term t2 = this.graph.getTerm("GO:0008150");
        Collection parents = this.graph.getSharedParents(t1.getID(), t2.getID());
        Assert.assertEquals((long)2L, (long)parents.size());
        Assert.assertTrue((boolean)parents.containsAll(OntologyTest.newTermIDCollection("GO:0008150", "GO:0000000")));
    }

    @Test
    public void testGetSharedParentsTwoLeaves() {
        Term t1 = this.graph.getTerm("GO:0034641");
        Term t2 = this.graph.getTerm("GO:0019326");
        Collection actual = this.graph.getSharedParents(t1.getID(), t2.getID());
        Set expected = this.graph.getTermsOfInducedGraph(null, t1.getID());
        expected.retainAll(this.graph.getTermsOfInducedGraph(null, t2.getID()));
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        Assert.assertTrue((boolean)actual.containsAll(expected));
    }

    @Test
    public void testRelevantSubontology() {
        this.graph.setRelevantSubontology("biological_process");
        Ontology biologicalProcess = this.graph.getOntlogyOfRelevantTerms();
        Assert.assertEquals((long)21763L, (long)biologicalProcess.getNumberOfTerms());
        Assert.assertEquals((Object)"biological_process", (Object)biologicalProcess.getRootTerm().getName().toString());
        Namespace n = biologicalProcess.getRootTerm().getNamespace();
        ByteString nn = n.getName();
        Assert.assertEquals((Object)"biological_process", (Object)nn.toString());
        for (Term t : biologicalProcess) {
            Assert.assertEquals((Object)nn, (Object)t.getNamespace().getName());
        }
    }

    private static Set<String> subsetNames(Collection<Subset> subsets) {
        HashSet<String> names = new HashSet<String>();
        for (Subset s : subsets) {
            names.add(s.getName().toString());
        }
        return names;
    }

    private static Set<String> subsetNames(Subset[] subsets) {
        HashSet<String> names = new HashSet<String>();
        for (Subset s : subsets) {
            names.add(s.getName().toString());
        }
        return names;
    }

    private static Set<String> termNames(Collection<TermID> terms) {
        HashSet<String> names = new HashSet<String>();
        for (TermID t : terms) {
            names.add(t.toString());
        }
        return names;
    }

    @Test
    public void testSubsetOntology() {
        HashSet<String> expectedSubsets = new HashSet<String>(Arrays.asList("goslim_aspergillus", "goslim_candida", "goslim_generic", "goslim_pir", "goslim_plant", "goslim_pombe", "goslim_yeast", "gosubset_prok", "high_level_annotation_qc", "mf_needs_review"));
        Assert.assertEquals(expectedSubsets, OntologyTest.subsetNames(this.graph.getAvailableSubsets()));
        this.graph.setRelevantSubset("goslim_generic");
        Ontology goslim = this.graph.getOntlogyOfRelevantTerms();
        int expectedGoSlimTerms = 0;
        for (Term t : this.graph) {
            if (!OntologyTest.subsetNames(t.getSubsets()).contains("goslim_generic")) continue;
            ++expectedGoSlimTerms;
        }
        Assert.assertEquals((long)expectedGoSlimTerms, (long)goslim.getNumberOfTerms());
    }

    @Test
    public void testSlimSubsetInternalOntology() {
        Ontology o = new InternalOntology().graph;
        HashSet<String> expectedSubsets = new HashSet<String>(Arrays.asList("slim"));
        Assert.assertEquals(expectedSubsets, OntologyTest.subsetNames(o.getAvailableSubsets()));
        o.setRelevantSubset("slim");
        Ontology slim = o.getOntlogyOfRelevantTerms();
        Assert.assertEquals((long)5L, (long)slim.getNumberOfTerms());
        HashSet<String> expectedTerms = new HashSet<String>(Arrays.asList("GO:0000002", "GO:0000003"));
        Assert.assertEquals(expectedTerms, OntologyTest.termNames(slim.getTermChildren(new TermID("GO:0000001"))));
        expectedTerms = new HashSet<String>(Arrays.asList("GO:0000007"));
        Assert.assertEquals(expectedTerms, OntologyTest.termNames(slim.getTermChildren(new TermID("GO:0000002"))));
        expectedTerms = new HashSet<String>(Arrays.asList("GO:0000007"));
        Assert.assertEquals(expectedTerms, OntologyTest.termNames(slim.getTermChildren(new TermID("GO:0000003"))));
        expectedTerms = new HashSet<String>(Arrays.asList("GO:0000010"));
        Assert.assertEquals(expectedTerms, OntologyTest.termNames(slim.getTermChildren(new TermID("GO:0000007"))));
    }

    @Test
    public void testGOLevelsEmpty() {
        Ontology.GOLevels noLevels = this.graph.getGOLevels(new HashSet());
        Assert.assertEquals((long)-1L, (long)noLevels.getMaxLevel());
        Assert.assertEquals((long)-1L, (long)noLevels.getTermLevel((TermID)this.graph.getLeafTermIDs().iterator().next()));
        Ontology.GOLevels twoLevels = this.graph.getGOLevels(new HashSet(this.graph.getTermChildren(this.graph.getRootTerm().getID())));
        Assert.assertEquals((long)1L, (long)twoLevels.getMaxLevel());
        Ontology.GOLevels allLevels = this.graph.getGOLevels(Ontology.termIDSet((Iterable)this.graph.getGraph().getVertices()));
        Assert.assertEquals((long)20L, (long)allLevels.getMaxLevel());
    }

    @Test
    public void testIsArtificialRootTerm() {
        Ontology o = new InternalOntology().graph;
        Assert.assertFalse((boolean)o.isArtificialRootTerm(new TermID("GO:0000001")));
        Assert.assertFalse((boolean)o.isArtificialRootTerm(new TermID("GO:0000002")));
        Assert.assertFalse((boolean)o.isArtificialRootTerm(new TermID("GO:0000003")));
    }

    @Test
    public void testGOLevelInternalOntology() {
        Ontology o = new InternalOntology().graph;
        Ontology.GOLevels levels = o.getGOLevels(Ontology.termIDSet((Iterable)o.getGraph().getVertices()));
        Assert.assertEquals((long)5L, (long)levels.getMaxLevel());
        Assert.assertEquals((long)0L, (long)levels.getTermLevel(new TermID("GO:0000001")));
        Assert.assertEquals((long)1L, (long)levels.getTermLevel(new TermID("GO:0000002")));
        Assert.assertEquals((long)1L, (long)levels.getTermLevel(new TermID("GO:0000003")));
        Assert.assertEquals((long)2L, (long)levels.getTermLevel(new TermID("GO:0000004")));
        Assert.assertEquals((long)2L, (long)levels.getTermLevel(new TermID("GO:0000005")));
        Assert.assertEquals((long)2L, (long)levels.getTermLevel(new TermID("GO:0000006")));
        Assert.assertEquals((long)3L, (long)levels.getTermLevel(new TermID("GO:0000007")));
        Assert.assertEquals((long)4L, (long)levels.getTermLevel(new TermID("GO:0000008")));
        Assert.assertEquals((long)4L, (long)levels.getTermLevel(new TermID("GO:0000009")));
        Assert.assertEquals((long)5L, (long)levels.getTermLevel(new TermID("GO:0000010")));
        Assert.assertEquals((long)5L, (long)levels.getTermLevel(new TermID("GO:0000011")));
    }
}

