/*
 * Decompiled with CFR 0.152.
 */
package ontologizer.io.obo;

import ontologizer.io.obo.IParserInput;
import ontologizer.io.obo.OBOParser;
import ontologizer.io.obo.OBOParserFileInput;
import ontologizer.io.obo.OBOParserTest;
import ontologizer.ontology.ParentTermID;
import ontologizer.ontology.Term;
import ontologizer.ontology.TermContainer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ParsedContainerTest {
    public TermContainer container;
    private OBOParser oboParser;
    private Term bioproc = new Term("GO:0008150", "biological_process", new ParentTermID[0]);
    private Term cellcomp = new Term("GO:0005575", "cellular_component", new ParentTermID[0]);
    private Term molfunc = new Term("GO:0003674", "molecular_function", new ParentTermID[0]);

    @Before
    public void setUp() throws Exception {
        this.oboParser = new OBOParser((IParserInput)new OBOParserFileInput(OBOParserTest.GOtermsOBOFile));
        this.oboParser.doParse();
        this.container = new TermContainer((Iterable)this.oboParser.getTermMap(), this.oboParser.getFormatVersion(), this.oboParser.getDate());
    }

    @Test
    public void testBasicStructure() {
        Assert.assertTrue((this.container.termCount() == this.oboParser.getTermMap().size() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.container.getFormatVersion().equals((Object)this.oboParser.getFormatVersion()));
        Assert.assertTrue((boolean)this.container.getDate().equals((Object)this.oboParser.getDate()));
        Assert.assertTrue((boolean)this.container.getName("GO:0008150").equals("biological_process"));
        Assert.assertTrue((boolean)this.container.getName(this.bioproc.getID()).equals("biological_process"));
        Assert.assertTrue((boolean)this.container.getName("GO:0005575").equals("cellular_component"));
        Assert.assertTrue((boolean)this.container.getName(this.cellcomp.getID()).equals("cellular_component"));
        Assert.assertTrue((boolean)this.container.getName("GO:0003674").equals("molecular_function"));
        Assert.assertTrue((boolean)this.container.getName(this.molfunc.getID()).equals("molecular_function"));
        Assert.assertTrue((boolean)this.container.get("GO:0008150").equals((Object)this.bioproc));
        Assert.assertTrue((boolean)this.container.get(this.bioproc.getID()).equals((Object)this.bioproc));
        Assert.assertTrue((boolean)this.container.get("GO:0005575").equals((Object)this.cellcomp));
        Assert.assertTrue((boolean)this.container.get(this.cellcomp.getID()).equals((Object)this.cellcomp));
        Assert.assertTrue((boolean)this.container.get("GO:0003674").equals((Object)this.molfunc));
        Assert.assertTrue((boolean)this.container.get(this.molfunc.getID()).equals((Object)this.molfunc));
        Assert.assertTrue((this.container.get("GO:9999999") == null ? 1 : 0) != 0);
        Term anotherTerm = new Term("GO:9999999", "dummy", new ParentTermID[0]);
        Assert.assertTrue((this.container.get(anotherTerm.getID()) == null ? 1 : 0) != 0);
    }
}

