/*
 * Decompiled with CFR 0.152.
 */
package ontologizer.io.annotation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import ontologizer.association.Association;
import ontologizer.association.SwissProtAffyAnnotation;
import ontologizer.association.SwissProtAffyAnnotationSet;
import ontologizer.io.annotation.IAssociationParserProgress;
import ontologizer.io.obo.IParserInput;
import ontologizer.ontology.TermID;
import ontologizer.ontology.TermMap;
import ontologizer.types.ByteString;

public class AffyParser {
    private static ByteString THREE_SLASHES = ByteString.b((String)"///");
    private static Logger logger = Logger.getLogger(AffyParser.class.getName());
    private ArrayList<Association> associations = new ArrayList();
    private HashMap<ByteString, ByteString> synonym2Symbol = new HashMap();

    public void parse(IParserInput input, byte[] head, HashSet<ByteString> names, TermMap terms, IAssociationParserProgress progress) throws IOException {
        int skipped;
        block17: {
            String line;
            String[] annot = new String[]{"Probe Set ID", "GeneChip Array", "Species Scientific Name", "Annotation Date", "Sequence Type", "Sequence Source", "Transcript ID(Array Design)", "Target Description", "Representative Public ID", "Archival UniGene Cluster", "UniGene ID", "Genome Version", "Alignments", "Gene Title", "Gene Symbol", "Chromosomal Location", "Unigene Cluster Type", "Ensembl", "Entrez Gene", "SwissProt", "EC", "OMIM", "RefSeq Protein ID", "RefSeq Transcript ID", "FlyBase", "AGI", "WormBase", "MGI Name", "RGD Name", "SGD accession number", "Gene Ontology Biological Process", "Gene Ontology Cellular Component", "Gene Ontology Molecular Function", "Pathway", "Protein Families", "Protein Domains", "InterPro", "Trans Membrane", "QTL", "Annotation Description", "Annotation Transcript Cluster", "Transcript Assignments", "Annotation Notes"};
            if (progress != null) {
                progress.init(input.getSize());
            }
            skipped = 0;
            long millis = 0L;
            PushbackInputStream pis = new PushbackInputStream(input.inputStream());
            pis.unread(head);
            BufferedReader in = new BufferedReader(new InputStreamReader(pis));
            while ((line = in.readLine()).startsWith("#")) {
            }
            boolean headerFailure = false;
            String delim = ",";
            String[] fields = line.split(delim);
            for (int i = 0; i < 33; ++i) {
                String item = fields[i];
                int x = item.indexOf(34) + 1;
                int y = item.lastIndexOf(34);
                if (x == 0 && y == item.length() - 1) {
                    System.out.print("OK");
                }
                if ((item = item.substring(x, y)).equals(annot[i])) continue;
                logger.severe("Found column header \"" + item + "\" but expected \"" + annot[i] + "\"");
                headerFailure = true;
                break;
            }
            if (headerFailure) break block17;
            SwissProtAffyAnnotationSet annotationSet = new SwissProtAffyAnnotationSet();
            while ((line = in.readLine()) != null) {
                long newMillis;
                if (progress != null && (newMillis = System.currentTimeMillis()) - millis > 250L) {
                    progress.update(input.getPosition());
                    millis = newMillis;
                }
                ByteString probeid = null;
                ByteString swiss = null;
                LinkedList<TermID> termList = new LinkedList<TermID>();
                int len = line.length();
                int x = -1;
                int idx = 0;
                for (int i = 0; i < len; ++i) {
                    block19: {
                        String[] ids;
                        int y;
                        block20: {
                            String s;
                            block21: {
                                block18: {
                                    if (line.charAt(i) != '\"') continue;
                                    if (x == -1) {
                                        x = i;
                                        continue;
                                    }
                                    y = i;
                                    if (y <= x) continue;
                                    if (idx != 0) break block18;
                                    probeid = new ByteString(line.substring(x + 1, y));
                                    break block19;
                                }
                                if (idx != 14) break block20;
                                s = line.substring(x + 1, y);
                                if (!s.startsWith("---")) break block21;
                                swiss = null;
                                break block19;
                            }
                            swiss = new ByteString(s);
                            int sepIndex = swiss.indexOf(THREE_SLASHES);
                            if (sepIndex == -1) break block19;
                            swiss = swiss.trimmedSubstring(0, sepIndex);
                            break block19;
                        }
                        if ((idx == 30 || idx == 31 || idx == 32) && (ids = line.substring(x + 1, y).split("///")) != null) {
                            for (int j = 0; j < ids.length; ++j) {
                                String number = ids[j].contains("/") ? ids[j].substring(0, ids[j].indexOf(47)).trim() : ids[j].trim();
                                try {
                                    int goId = Integer.parseInt(number);
                                    TermID id = new TermID(TermID.DEFAULT_PREFIX, goId);
                                    if (terms.get(id) != null) {
                                        termList.add(id);
                                        continue;
                                    }
                                    ++skipped;
                                    continue;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    ++idx;
                    x = -1;
                }
                if (swiss != null && swiss.length() > 0) {
                    annotationSet.add(swiss, probeid, termList);
                    continue;
                }
                if (termList.size() <= 0) continue;
                annotationSet.add(probeid, probeid, termList);
            }
            for (SwissProtAffyAnnotation swissAnno : annotationSet) {
                ByteString swissID = swissAnno.getSwissProtID();
                for (TermID goID : swissAnno.getGOIDs()) {
                    Association assoc = new Association(swissID, goID);
                    this.associations.add(assoc);
                }
                for (ByteString affy : swissAnno.getAffyIDs()) {
                    this.synonym2Symbol.put(affy, swissID);
                }
            }
        }
        logger.log(Level.INFO, "skipped {} annotations", new Object[]{skipped});
    }

    public ArrayList<Association> getAssociations() {
        return this.associations;
    }

    public HashMap<ByteString, ByteString> getSynonym2Symbol() {
        return this.synonym2Symbol;
    }
}

