/*
 * Decompiled with CFR 0.152.
 */
package ontologizer.io.annotation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import ontologizer.association.AnnotationContext;
import ontologizer.association.Association;
import ontologizer.io.annotation.AffyParser;
import ontologizer.io.annotation.GAFByteLineScanner;
import ontologizer.io.annotation.IAssociationParserProgress;
import ontologizer.io.linescanner.AbstractByteLineScanner;
import ontologizer.io.obo.IParserInput;
import ontologizer.ontology.TermID;
import ontologizer.ontology.TermMap;
import ontologizer.types.ByteString;

public class AssociationParser {
    private static Logger logger = Logger.getLogger(AssociationParser.class.getName());
    private IParserInput input;
    private TermMap terms;
    private HashSet<ByteString> names;
    private Collection<String> evidences;
    private IAssociationParserProgress progress;
    private boolean iterative;
    private boolean parsingFinished;
    private ArrayList<Association> associations;
    private AnnotationContext annotationMapping;
    private Type fileType = Type.UNKNOWN;
    private int symbolWarnings;
    private int dbObjectWarnings;

    public AssociationParser(IParserInput input, TermMap terms) throws IOException {
        this(input, terms, null);
    }

    public AssociationParser(IParserInput input, TermMap terms, HashSet<ByteString> names) throws IOException {
        this(input, terms, names, null);
    }

    public AssociationParser(IParserInput input, TermMap terms, HashSet<ByteString> names, IAssociationParserProgress progress) throws IOException {
        this(input, terms, names, null, progress);
    }

    public AssociationParser(IParserInput input, TermMap terms, HashSet<ByteString> names, Collection<String> evidences, IAssociationParserProgress progress) throws IOException {
        this(input, terms, names, evidences, progress, false);
    }

    public AssociationParser(IParserInput input, TermMap terms, HashSet<ByteString> names, Collection<String> evidences, IAssociationParserProgress progress, boolean iterative) throws IOException {
        this.input = input;
        this.terms = terms;
        this.names = names;
        this.evidences = evidences;
        this.progress = progress;
        this.iterative = iterative;
        this.associations = new ArrayList();
        if (iterative) {
            return;
        }
        this.parse();
    }

    public boolean parse() throws IOException {
        if (this.parsingFinished) {
            return true;
        }
        long startMillis = System.currentTimeMillis();
        if (this.input.getFilename().endsWith(".ids")) {
            this.importIDSAssociation(this.input, this.terms, this.progress);
            this.fileType = Type.IDS;
        } else {
            final ArrayList lines = new ArrayList();
            AbstractByteLineScanner abls = new AbstractByteLineScanner(this.input.inputStream()){

                @Override
                public boolean newLine(byte[] buf, int start, int len) {
                    if (len > 0 && buf[start] != 35) {
                        byte[] b = new byte[len + 1];
                        System.arraycopy(buf, start, b, 0, len);
                        b[len] = 10;
                        lines.add(b);
                        return false;
                    }
                    return true;
                }
            };
            abls.scan();
            if (lines.size() == 0) {
                return true;
            }
            byte[] head = AssociationParser.merge((byte[])lines.get(0), abls.availableBuffer());
            if (new String(head).startsWith("\"Probe Set ID\",\"GeneChip Array\"")) {
                AffyParser ap = new AffyParser();
                ap.parse(this.input, head, this.names, this.terms, this.progress);
                this.associations = ap.getAssociations();
                HashSet<ByteString> allSymbols = new HashSet<ByteString>();
                for (Association a : this.associations) {
                    allSymbols.add(a.getObjectSymbol());
                }
                this.annotationMapping = new AnnotationContext(allSymbols, ap.getSynonym2Symbol(), new HashMap());
                this.fileType = Type.AFFYMETRIX;
            } else {
                this.importGAF(this.input, head, this.names, this.terms, this.evidences, this.progress);
                this.fileType = Type.GAF;
            }
        }
        long durationMillis = System.currentTimeMillis() - startMillis;
        if (durationMillis == 0L) {
            durationMillis = 1L;
        }
        logger.log(Level.INFO, "Parsed annotations in " + durationMillis + " ms (" + (long)(this.associations.size() * 1000) / durationMillis + " per second)");
        this.parsingFinished = true;
        return true;
    }

    private void importIDSAssociation(IParserInput input, TermMap terms, IAssociationParserProgress progress) {
        try {
            String line;
            BufferedReader is = new BufferedReader(new InputStreamReader(input.inputStream()));
            while ((line = is.readLine()) != null) {
                String[] fields;
                if (line.equalsIgnoreCase("GoStat IDs Format Version 1.0") || (fields = line.split("\t", 2)).length != 2) continue;
                String[] annotatedTerms = fields[1].split(",");
                for (int i = 0; i < annotatedTerms.length; ++i) {
                    TermID tid;
                    try {
                        tid = new TermID(annotatedTerms[i]);
                    }
                    catch (IllegalArgumentException ex) {
                        int id = new Integer(annotatedTerms[i]);
                        tid = new TermID(TermID.DEFAULT_PREFIX, id);
                    }
                    if (terms.get(tid) != null) {
                        Association assoc = new Association(new ByteString(fields[0]), tid.toString());
                        this.associations.add(assoc);
                        continue;
                    }
                    logger.warning(tid.toString() + " which annotates " + fields[0] + " not found");
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Set<ByteString> getByteStringSetFromStringCollection(Collection<String> strings) {
        HashSet<ByteString> byteStrings;
        if (strings != null) {
            byteStrings = new HashSet<ByteString>();
            for (String e : strings) {
                byteStrings.add(new ByteString(e));
            }
        } else {
            byteStrings = null;
        }
        return byteStrings;
    }

    private void importGAF(IParserInput input, byte[] head, HashSet<ByteString> names, TermMap terms, Collection<String> evidences, IAssociationParserProgress progress) throws IOException {
        if (progress != null) {
            progress.init(input.getSize());
        }
        GAFByteLineScanner ls = new GAFByteLineScanner(input, head, names, terms, AssociationParser.getByteStringSetFromStringCollection(evidences), progress);
        ls.scan();
        if (progress != null) {
            progress.update(input.getSize());
        }
        logger.log(Level.INFO, ls.good + " associations parsed, " + ls.kept + " of which were kept while " + ls.bad + " malformed lines had to be ignored.");
        logger.log(Level.INFO, "A further " + ls.skipped + " associations were skipped due to various reasons whereas " + ls.nots + " of those where explicitly qualified with NOT, " + ls.obsolete + " referred to obsolete terms and " + ls.evidenceMismatch + " didn't match the requested evidence codes");
        logger.log(Level.INFO, "A total of " + ls.getNumberOfUsedTerms() + " terms are directly associated to " + ls.getAnnotationContext().getSymbols().length + " items.");
        this.associations = ls.getAssociations();
        this.annotationMapping = ls.getAnnotationContext();
        if (this.symbolWarnings >= 1000) {
            logger.warning("The symbols of a total of " + this.symbolWarnings + " entries mapped ambiguously");
        }
        if (this.dbObjectWarnings >= 1000) {
            logger.warning("The objects of a  total of " + this.dbObjectWarnings + " entries mapped ambiguously");
        }
    }

    public ArrayList<Association> getAssociations() {
        return this.associations;
    }

    public AnnotationContext getAnnotationMapping() {
        return this.annotationMapping;
    }

    public List<ByteString> getListOfObjectSymbols() {
        ArrayList<ByteString> arrayList = new ArrayList<ByteString>();
        for (Association assoc : this.associations) {
            arrayList.add(assoc.getObjectSymbol());
        }
        return arrayList;
    }

    public Type getFileType() {
        return this.fileType;
    }

    private static byte[] merge(byte[] a1, byte[] a2) {
        byte[] b = new byte[a1.length + a2.length];
        System.arraycopy(a1, 0, b, 0, a1.length);
        System.arraycopy(a2, 0, b, a1.length, a2.length);
        return b;
    }

    static enum Type {
        UNKNOWN,
        GAF,
        IDS,
        AFFYMETRIX;

    }
}

