/*
 * Decompiled with CFR 0.152.
 */
package ontologizer.io.annotation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import ontologizer.association.AnnotationContext;
import ontologizer.association.Association;
import ontologizer.io.annotation.IAssociationParserProgress;
import ontologizer.io.linescanner.AbstractByteLineScanner;
import ontologizer.io.obo.IParserInput;
import ontologizer.ontology.PrefixPool;
import ontologizer.ontology.Term;
import ontologizer.ontology.TermID;
import ontologizer.ontology.TermMap;
import ontologizer.types.ByteString;
import sonumina.collections.ObjectIntHashMap;

class GAFByteLineScanner
extends AbstractByteLineScanner {
    private static Logger logger = Logger.getLogger(GAFByteLineScanner.class.getName());
    private static final byte PIPE = 124;
    private IParserInput input;
    private Set<ByteString> names;
    private TermMap terms;
    private Set<ByteString> evidences;
    private IAssociationParserProgress progress;
    private int lineno = 0;
    private long millis = 0L;
    public int good = 0;
    public int bad = 0;
    public int skipped = 0;
    public int nots = 0;
    public int evidenceMismatch = 0;
    public int kept = 0;
    public int obsolete = 0;
    private int symbolWarnings = 0;
    private int dbObjectWarnings = 0;
    private ArrayList<Association> associations = new ArrayList();
    private PrefixPool prefixPool = new PrefixPool();
    private HashMap<TermID, Term> altTermID2Term = null;
    private HashSet<TermID> usedGoTerms = new HashSet();
    private List<ByteString> items = new ArrayList<ByteString>();
    private List<ByteString> objectIds = new ArrayList<ByteString>();
    private ObjectIntHashMap<ByteString> objectSymbolMap = new ObjectIntHashMap();
    private ObjectIntHashMap<ByteString> objectIdMap = new ObjectIntHashMap();
    private ObjectIntHashMap<ByteString> synonymMap = new ObjectIntHashMap();

    public GAFByteLineScanner(IParserInput input, byte[] head, Set<ByteString> names, TermMap terms, Set<ByteString> evidences, IAssociationParserProgress progress) {
        super(input.inputStream());
        this.push(head);
        this.input = input;
        this.names = names;
        this.terms = terms;
        this.evidences = evidences;
        this.progress = progress;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean newLine(byte[] buf, int start, int len) {
        ByteString[] synonyms;
        Association assoc;
        block26: {
            boolean keep;
            block24: {
                block25: {
                    block23: {
                        long newMillis;
                        if (this.progress != null && (newMillis = System.currentTimeMillis()) - this.millis > 250L) {
                            this.progress.update(this.input.getPosition());
                            this.millis = newMillis;
                        }
                        ++this.lineno;
                        if (len < 1 || buf[start] == 33) {
                            return true;
                        }
                        assoc = Association.createFromGAFLine((byte[])buf, (int)start, (int)len, (PrefixPool)this.prefixPool);
                        TermID currentTermID = assoc.getTermID();
                        ++this.good;
                        if (assoc.hasNotQualifier()) {
                            ++this.skipped;
                            ++this.nots;
                            return true;
                        }
                        if (this.evidences != null && !this.evidences.contains(assoc.getEvidence())) {
                            ++this.skipped;
                            ++this.evidenceMismatch;
                            return true;
                        }
                        Term currentTerm = this.terms.get(currentTermID);
                        if (currentTerm == null) {
                            if (this.altTermID2Term == null) {
                                this.altTermID2Term = new HashMap();
                                for (Term t : this.terms) {
                                    for (TermID altID : t.getAlternatives()) {
                                        this.altTermID2Term.put(altID, t);
                                    }
                                }
                            }
                            if ((currentTerm = this.altTermID2Term.get(currentTermID)) == null) {
                                logger.log(Level.WARNING, "Skipping association of the item \"{}\" t {} because the term was not found! Are the OBO file and the association file both up-to-date?", new Object[]{assoc.getObjectSymbol(), currentTermID});
                                ++this.skipped;
                                return true;
                            }
                            currentTermID = currentTerm.getID();
                            assoc.setTermID(currentTermID);
                        } else {
                            currentTermID = currentTerm.getID();
                            assoc.setTermID(currentTermID);
                        }
                        this.usedGoTerms.add(currentTermID);
                        if (currentTerm.isObsolete()) {
                            logger.log(Level.WARNING, "Skipping association of the item \"{}\" t {} because the term was not found! Are the OBO file and the association file both up-to-date?", new Object[]{assoc.getObjectSymbol(), currentTermID});
                            ++this.skipped;
                            ++this.obsolete;
                            return true;
                        }
                        synonyms = assoc.getSynonym() != null && assoc.getSynonym().length() > 2 ? assoc.getSynonym().split((byte)124) : null;
                        if (this.names == null) break block23;
                        keep = false;
                        if (synonyms == null) break block24;
                        break block25;
                    }
                    ++this.kept;
                    break block26;
                }
                for (int i = 0; i < synonyms.length; ++i) {
                    if (!this.names.contains(synonyms[i])) continue;
                    keep = true;
                    break;
                }
            }
            if (!(keep || this.names.contains(assoc.getObjectSymbol()) || this.names.contains(assoc.getDB_Object()))) {
                ++this.skipped;
                return true;
            }
            ++this.kept;
        }
        this.associations.add(assoc);
        ByteString objectSymbol = assoc.getObjectSymbol();
        int potentialObjectIndex = this.items.size();
        int objectIndex = this.objectSymbolMap.getIfAbsentPut((Object)objectSymbol, potentialObjectIndex);
        if (objectIndex == potentialObjectIndex) {
            this.items.add(objectSymbol);
            this.objectIds.add(assoc.getDB_Object());
        } else if (!assoc.getDB_Object().equals((Object)this.objectIds.get(objectIndex))) {
            this.synonymMap.put((Object)assoc.getDB_Object(), objectIndex);
            ++this.dbObjectWarnings;
            if (this.dbObjectWarnings < 1000) {
                String warning = "Line " + this.lineno + ": Expected that symbol \"" + assoc.getObjectSymbol() + "\" maps to \"" + this.objectIds.get(objectIndex) + "\" but it maps to \"" + assoc.getDB_Object() + "\"";
                if (this.progress != null) {
                    this.progress.warning(warning);
                }
                logger.warning(warning);
            }
        }
        int objectIdIndex = this.objectIdMap.getIfAbsentPut((Object)assoc.getDB_Object(), objectIndex);
        if (objectIdIndex != objectIndex) {
            ++this.symbolWarnings;
            if (this.symbolWarnings < 1000) {
                String warning = "Line " + this.lineno + ": Expected that dbObject \"" + assoc.getDB_Object() + "\" maps to symbol \"" + this.items.get(objectIdIndex) + "\" but it maps to \"" + assoc.getObjectSymbol() + "\"";
                if (this.progress != null) {
                    this.progress.warning(warning);
                }
                logger.warning(warning);
            }
        }
        if (synonyms != null) {
            for (ByteString synonym : synonyms) {
                this.synonymMap.put((Object)synonym, objectIndex);
            }
        }
        return true;
    }

    public int getNumberOfUsedTerms() {
        return this.usedGoTerms.size();
    }

    public ArrayList<Association> getAssociations() {
        return this.associations;
    }

    public AnnotationContext getAnnotationContext() {
        return new AnnotationContext(this.items, this.objectIds, this.objectSymbolMap, this.objectIdMap, this.synonymMap);
    }
}

