/*
 * Decompiled with CFR 0.152.
 */
package ontologizer.io.dot;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import sonumina.math.graph.AbstractGraph;

public class DOTWriter {
    public static <V> void write(AbstractGraph<V> g, OutputStream os, Iterable<V> nodeSet, final AbstractGraph.DotAttributesProvider<V> provider, final double nodeSep, final double rankSep) {
        AbstractGraph.DotAttributesProvider newProvider = new AbstractGraph.DotAttributesProvider<V>(){

            public String getDotGraphAttributes() {
                StringBuilder attrs = new StringBuilder();
                attrs.append(String.format(Locale.US, "nodesep=%f; ranksep=%f;", nodeSep, rankSep));
                if (provider.getDotGraphAttributes() != null) {
                    attrs.append(provider.getDotGraphAttributes());
                }
                return attrs.toString();
            }

            public String getDotNodeAttributes(V vt) {
                return provider.getDotNodeAttributes(vt);
            }

            public String getDotEdgeAttributes(V src, V dest) {
                return provider.getDotEdgeAttributes(src, dest);
            }

            public String getDotHeader() {
                return provider.getDotHeader();
            }
        };
        DOTWriter.write(g, os, nodeSet, newProvider);
    }

    public static <V> void write(AbstractGraph<V> g, OutputStream os, Iterable<V> nodeSet, AbstractGraph.DotAttributesProvider<V> provider) {
        PrintWriter out = new PrintWriter(os);
        String graphHeader = provider.getDotHeader();
        String graphAttributes = provider.getDotGraphAttributes();
        if (graphHeader != null) {
            out.append(graphHeader);
            out.append("\n");
        }
        out.append("digraph G {");
        if (graphAttributes != null) {
            out.append(graphAttributes);
            out.append('\n');
        }
        HashMap<V, Integer> v2idx = new HashMap<V, Integer>();
        int i = 0;
        for (V v : nodeSet) {
            String attributes = provider.getDotNodeAttributes(v);
            String name = provider.getDotNodeName(v);
            if (name == null) {
                name = Integer.toString(i);
            }
            out.write(name);
            if (attributes != null) {
                out.write("[" + attributes + "]");
            }
            out.write(";\n");
            v2idx.put(v, i++);
        }
        for (V s : nodeSet) {
            Iterator ancest = g.getChildNodes(s);
            while (ancest.hasNext()) {
                Object d = ancest.next();
                if (!v2idx.containsKey(d)) continue;
                String sName = provider.getDotNodeName(s);
                String dName = provider.getDotNodeName(d);
                if (sName == null) {
                    sName = Integer.toString((Integer)v2idx.get(s));
                }
                if (dName == null) {
                    dName = Integer.toString((Integer)v2idx.get(d));
                }
                out.write(sName + " -> " + dName);
                String attributes = provider.getDotEdgeAttributes(s, d);
                if (attributes != null) {
                    out.write("[" + attributes + "]");
                }
                out.println(";\n");
            }
        }
        out.write("}\n");
        out.flush();
        out.close();
    }
}

