/*
 * Decompiled with CFR 0.152.
 */
package ontologizer.io.dot;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import ontologizer.io.dot.DOTWriter;
import ontologizer.io.dot.IDotAttributesProvider;
import ontologizer.ontology.Ontology;
import ontologizer.ontology.Term;
import ontologizer.ontology.TermID;
import ontologizer.ontology.TermRelation;
import ontologizer.util.VersionInfo;
import sonumina.math.graph.AbstractGraph;

public class GODOTWriter {
    private static Logger logger = Logger.getLogger(GODOTWriter.class.getCanonicalName());

    public static String encodeTermID(TermID termId) {
        return termId.toString().replace(':', '_');
    }

    public static TermID decodeTermID(String encodedTermId) {
        return new TermID(encodedTermId.replace('_', ':'));
    }

    public static void writeDOT(Ontology graph, File file, TermID rootTerm, Set<TermID> terms, IDotAttributesProvider provider) {
        GODOTWriter.writeDOT(graph, file, rootTerm, terms, provider, "nodesep=0.4;", false, false, null);
    }

    public static void writeDOT(final Ontology graph, File file, TermID rootTerm, Set<TermID> terms, final IDotAttributesProvider provider, final String graphAttrs, final boolean reverseDirection, final boolean edgeLabels, Set<TermID> ignoreTerms) {
        HashSet<Term> nodeSet = new HashSet<Term>();
        for (TermID term : terms) {
            if (!graph.termExists(term)) {
                throw new IllegalArgumentException("Requested term " + term.toString() + " couldn't be found in the graph");
            }
            if (nodeSet.contains(term)) continue;
            for (TermID it : graph.getTermsOfInducedGraph(rootTerm, term)) {
                nodeSet.add(graph.getTerm(it));
            }
        }
        if (ignoreTerms != null) {
            for (TermID it : ignoreTerms) {
                nodeSet.remove(graph.getTerm(it));
            }
        }
        try {
            DOTWriter.write(graph.getGraph(), new FileOutputStream(file), nodeSet, new AbstractGraph.DotAttributesProvider<Term>(){
                private String direction;
                {
                    this.direction = reverseDirection ? "" : "dir=\"back\"";
                }

                public String getDotNodeName(Term vt) {
                    return GODOTWriter.encodeTermID(vt.getID());
                }

                public String getDotNodeAttributes(Term vt) {
                    return provider.getDotNodeAttributes(vt.getID());
                }

                public String getDotGraphAttributes() {
                    return graphAttrs;
                }

                public String getDotHeader() {
                    return "/* Generated with OntologizerLib " + VersionInfo.getVersion() + " */";
                }

                public String getDotEdgeAttributes(Term src, Term dest) {
                    String label;
                    String color;
                    String relationName;
                    TermRelation rel = graph.getDirectRelation(src.getID(), dest.getID());
                    switch (rel) {
                        case IS_A: {
                            relationName = "is a";
                            break;
                        }
                        case PART_OF_A: {
                            relationName = "is part of";
                            break;
                        }
                        case REGULATES: {
                            relationName = "regulates";
                            break;
                        }
                        case POSITIVELY_REGULATES: {
                            relationName = "positively regulates";
                            break;
                        }
                        case NEGATIVELY_REGULATES: {
                            relationName = "negatively regulates";
                            break;
                        }
                        default: {
                            relationName = "";
                        }
                    }
                    switch (rel) {
                        case IS_A: {
                            color = "black";
                            break;
                        }
                        case PART_OF_A: {
                            color = "blue";
                            break;
                        }
                        case REGULATES: 
                        case POSITIVELY_REGULATES: 
                        case NEGATIVELY_REGULATES: {
                            color = "green";
                            break;
                        }
                        default: {
                            color = "black";
                        }
                    }
                    if (edgeLabels) {
                        label = provider.getDotEdgeAttributes(src.getID(), dest.getID());
                        if (label == null) {
                            label = "label=\"" + relationName + "\"";
                        }
                    } else {
                        label = null;
                    }
                    String tooltip = "tooltip=\"" + dest.getName() + " " + relationName + " " + src.getName() + "\"";
                    return "color=" + color + "," + this.direction + "," + tooltip + (label != null ? "," + label : "");
                }
            });
        }
        catch (IOException e) {
            logger.severe("Unable to create dot file: " + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }
}

