/*
 * Decompiled with CFR 0.152.
 */
package ontologizer.io.linescanner;

import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractByteLineScanner {
    private InputStream is;
    private final int BUF_SIZE = 65536;
    private int available;
    private int availableStart;
    byte[] byteBuf = new byte[131072];
    private byte[] pushedBytes;
    private int pushedCurrent = -1;

    public AbstractByteLineScanner(InputStream is) {
        this.is = is;
    }

    public void scan() throws IOException {
        int read;
        int read_offset = 0;
        block0: while ((read = this.read(this.byteBuf, read_offset, 65536) + read_offset) > read_offset) {
            int line_start = 0;
            for (int pos = 0; pos < read; ++pos) {
                if (this.byteBuf[pos] != 10) continue;
                if (!this.newLine(this.byteBuf, line_start, pos - line_start)) {
                    this.availableStart = pos + 1;
                    this.available = read - this.availableStart;
                    break block0;
                }
                line_start = pos + 1;
            }
            System.arraycopy(this.byteBuf, line_start, this.byteBuf, 0, read - line_start);
            read_offset = read - line_start;
        }
        if (read_offset != 0) {
            this.newLine(this.byteBuf, 0, read_offset);
        }
    }

    private int read(byte[] b, int off, int len) throws IOException {
        if (this.pushedBytes != null && this.pushedCurrent < this.pushedBytes.length) {
            int l = Math.min(len, this.pushedBytes.length - this.pushedCurrent);
            System.arraycopy(this.pushedBytes, this.pushedCurrent, b, off, l);
            this.pushedCurrent += l;
            return l;
        }
        return this.is.read(b, off, len);
    }

    public int available() {
        return this.available;
    }

    public byte[] availableBuffer() {
        byte[] b = new byte[this.available];
        System.arraycopy(this.byteBuf, this.availableStart, b, 0, this.available);
        return b;
    }

    public void push(byte[] bytes) {
        if (this.pushedBytes != null) {
            throw new IllegalArgumentException("push() may be called only once!");
        }
        this.pushedBytes = (byte[])bytes.clone();
        this.pushedCurrent = 0;
    }

    public abstract boolean newLine(byte[] var1, int var2, int var3);
}

