/*
 * Decompiled with CFR 0.152.
 */
package ontologizer.io.obo;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DescriptionParser {
    private static final Pattern termPattern = Pattern.compile("`([^`]*)` \\(([^)]*)\\)");
    private static final Pattern textPattern = Pattern.compile("([^`]+)`");

    public static void parse(String txt, IDescriptionPartCallback cb) {
        int pos = 0;
        while (pos < txt.length()) {
            String ptxt = txt.substring(pos);
            Matcher m = termPattern.matcher(ptxt);
            if (m.find() && m.start() == 0) {
                pos += m.end();
                cb.part(m.group(1), m.group(2));
                continue;
            }
            m = textPattern.matcher(ptxt);
            if (m.find()) {
                cb.part(m.group(1), null);
                pos += m.end() - 1;
                continue;
            }
            cb.part(ptxt, null);
            return;
        }
    }

    public static String parse(String txt) {
        final StringBuilder str = new StringBuilder();
        DescriptionParser.parse(txt, new IDescriptionPartCallback(){

            @Override
            public boolean part(String txt, String ref) {
                str.append(txt);
                return true;
            }
        });
        return str.toString();
    }

    public static interface IDescriptionPartCallback {
        public boolean part(String var1, String var2);
    }
}

