/*
 * Decompiled with CFR 0.152.
 */
package ontologizer.io.obo;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import ontologizer.io.linescanner.AbstractByteLineScanner;
import ontologizer.io.obo.IOBOParserProgress;
import ontologizer.io.obo.IParserInput;
import ontologizer.io.obo.OBOKeywords;
import ontologizer.io.obo.OBOParserException;
import ontologizer.ontology.Namespace;
import ontologizer.ontology.ParentTermID;
import ontologizer.ontology.PrefixPool;
import ontologizer.ontology.Subset;
import ontologizer.ontology.Term;
import ontologizer.ontology.TermID;
import ontologizer.ontology.TermRelation;
import ontologizer.ontology.TermXref;
import ontologizer.types.ByteString;
import sonumina.collections.ReferencePool;

public class OBOParser {
    private static Logger logger = Logger.getLogger(OBOParser.class.getName());
    public static final int PARSE_DEFINITIONS = 1;
    public static final int PARSE_XREFS = 2;
    public static final int PARSE_INTERSECTIONS = 4;
    public static final int SETNAMEEQUALTOID = 8;
    public static final int IGNORE_SYNONYMS = 16;
    private static final HashMap<Character, Character> escapeChars = new HashMap();
    private static final HashMap<Character, Character> unescapeChars = new HashMap();
    IParserInput input;
    private int options;
    private ByteString format_version;
    private ByteString date;
    private ByteString data_version;
    private HashSet<Term> terms = new HashSet();
    private HashMap<ByteString, Subset> subsets = new HashMap();
    private int numberOfRelations;
    private PrefixPool prefixPool = new PrefixPool();
    private ReferencePool<TermID> termIDPool = new ReferencePool();
    private HashMap<ByteString, Namespace> namespaces = new HashMap();
    private Stanza currentStanza;
    private TermID currentID;
    private ByteString currentName;
    private Namespace currentNamespace;
    private ByteString currentDefintion;
    private boolean currentObsolete;
    private ArrayList<ParentTermID> currentParents = new ArrayList();
    private ArrayList<TermID> currentAlternatives = new ArrayList();
    private ArrayList<TermID> currentEquivalents = new ArrayList();
    private ArrayList<ByteString> currentSynonyms = new ArrayList();
    private ArrayList<Subset> currentSubsets = new ArrayList();
    private ArrayList<TermXref> currentXrefs = new ArrayList();

    public OBOParser(IParserInput input) {
        this(input, 0);
    }

    public OBOParser(IParserInput input, int options) {
        this.input = input;
        this.options = options;
    }

    public Set<Term> getTermMap() {
        return this.terms;
    }

    private void enterNewTerm() {
        if (this.currentStanza != null) {
            if (this.currentStanza == Stanza.TYPEDEF) {
                return;
            }
            if (this.currentName == null && this.currentID != null) {
                this.currentName = this.currentID.toByteString();
            }
            if (this.currentID == null || this.currentName == null) {
                logger.warning("Error parsing stanza: " + this.currentStanza.toString() + " currentID: " + this.currentID + ", currentName: " + this.currentName);
                this.resetCurrentStanza();
                return;
            }
            Term t = new Term(this.currentID, this.currentName, this.currentNamespace, this.currentParents);
            t.setObsolete(this.currentObsolete);
            t.setDefinition(this.currentDefintion);
            t.setAlternatives(this.currentAlternatives);
            t.setEquivalents(this.currentEquivalents);
            t.setSubsets(this.currentSubsets);
            t.setSynonyms(this.currentSynonyms);
            t.setXrefs(this.currentXrefs);
            this.terms.add(t);
            this.numberOfRelations += this.currentParents.size();
        }
        this.resetCurrentStanza();
    }

    private void resetCurrentStanza() {
        this.currentID = null;
        this.currentName = null;
        this.currentNamespace = null;
        this.currentDefintion = null;
        this.currentObsolete = false;
        this.currentParents.clear();
        this.currentAlternatives.clear();
        this.currentEquivalents.clear();
        this.currentSubsets.clear();
        this.currentSynonyms.clear();
        this.currentXrefs.clear();
    }

    public String doParse() throws IOException, OBOParserException {
        return this.doParse(null);
    }

    public String doParse(final IOBOParserProgress progress) throws IOException, OBOParserException {
        long startMillis = System.currentTimeMillis();
        if (progress != null) {
            progress.init(this.input.getSize());
        }
        class OBOByteLineScanner
        extends AbstractByteLineScanner {
            private int linenum;
            private long millis;
            public int currentTerm;
            private byte[] multilineBuf;
            private byte[] line;
            private int start;
            private int len;
            private byte[] temp;
            public OBOParserException exception;

            public OBOByteLineScanner(InputStream is) {
                super(is);
                this.millis = 0L;
                this.currentTerm = 0;
            }

            private void updateProgress() {
                long newMillis;
                if (progress != null && (newMillis = System.currentTimeMillis()) - this.millis > 250L) {
                    int pos = OBOParser.this.input.getPosition();
                    if (pos >= 0) {
                        progress.update(pos, this.currentTerm);
                    }
                    this.millis = newMillis;
                }
            }

            private void expandMultilibeBuf(byte[] buf, int start, int len) {
                int oldlen = this.multilineBuf != null ? this.multilineBuf.length : 0;
                byte[] newMultilineBuf = new byte[oldlen + len];
                if (oldlen != 0) {
                    System.arraycopy(this.multilineBuf, 0, newMultilineBuf, 0, oldlen);
                }
                System.arraycopy(buf, start, newMultilineBuf, oldlen, len);
                this.multilineBuf = newMultilineBuf;
            }

            private String getLineContens() {
                return new ByteString(this.line, this.start, this.start + this.len).toString();
            }

            private boolean equalsIgnoreCase(byte[] buf, int start, int len, byte[] cmp) {
                if (cmp.length != len) {
                    return false;
                }
                for (int i = 0; i < len; ++i) {
                    byte c = buf[start + i];
                    if (c >= 65 && c <= 90) {
                        c = (byte)(c + 32);
                    }
                    if (cmp[i] == c) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean newLine(byte[] buf, int start, int len) {
                ++this.linenum;
                this.updateProgress();
                if (len == 0) {
                    return true;
                }
                if (buf[start + len - 1] == 92) {
                    this.expandMultilibeBuf(buf, start, len - 1);
                    return true;
                }
                if (this.multilineBuf != null) {
                    this.expandMultilibeBuf(buf, start, len);
                    buf = this.multilineBuf;
                    start = 0;
                    len = this.multilineBuf.length;
                }
                this.multilineBuf = null;
                if (buf[start] == 33) {
                    return true;
                }
                while (len != 0 && Character.isWhitespace(buf[start + len - 1])) {
                    --len;
                }
                if (len == 0) {
                    return true;
                }
                this.line = buf;
                this.start = start;
                this.len = len;
                if (buf[start] == 91) {
                    OBOParser.this.enterNewTerm();
                    ++this.currentTerm;
                    if (buf[start + len - 1] != 93) {
                        this.exception = new OBOParserException("Unclosed stanza", this.getLineContens(), this.linenum);
                        return false;
                    }
                    if (this.equalsIgnoreCase(this.line, ++start, len -= 2, OBOKeywords.TERM_KEYWORD)) {
                        OBOParser.this.currentStanza = Stanza.TERM;
                    } else if (this.equalsIgnoreCase(this.line, start, len, OBOKeywords.TYPEDEF_KEYWORD)) {
                        OBOParser.this.currentStanza = Stanza.TYPEDEF;
                    } else {
                        this.exception = new OBOParserException("Unknown stanza type", this.getLineContens(), this.linenum);
                        return false;
                    }
                    ++this.currentTerm;
                } else {
                    int i;
                    int keyEnd = -1;
                    int valueStart = -1;
                    for (i = start; i < start + len; ++i) {
                        if (buf[i] != 58) continue;
                        keyEnd = i;
                        break;
                    }
                    if (keyEnd == -1) {
                        return true;
                    }
                    for (i = keyEnd + 1; i < start + len; ++i) {
                        if (Character.isWhitespace(buf[i])) continue;
                        valueStart = i;
                        break;
                    }
                    if (valueStart == -1) {
                        return true;
                    }
                    int keyStart = start;
                    int keyLen = keyEnd - start;
                    int valueLen = start + len - valueStart;
                    if (OBOParser.this.currentStanza == null) {
                        this.readHeaderValue(this.line, keyStart, keyLen, valueStart, valueLen);
                    } else if (OBOParser.this.currentStanza == Stanza.TERM) {
                        this.readTermValue(this.line, keyStart, keyLen, valueStart, valueLen);
                    }
                }
                return true;
            }

            private void readHeaderValue(byte[] buf, int keyStart, int keyLen, int valueStart, int valueLen) {
                if (this.equalsIgnoreCase(buf, keyStart, keyLen, OBOKeywords.FORMAT_VERSION_KEYWORD)) {
                    OBOParser.this.format_version = new ByteString(buf, valueStart, valueStart + valueLen);
                } else if (this.equalsIgnoreCase(buf, keyStart, keyLen, OBOKeywords.DATE_KEYWORD)) {
                    OBOParser.this.date = new ByteString(buf, valueStart, valueStart + valueLen);
                } else if (this.equalsIgnoreCase(buf, keyStart, keyLen, OBOKeywords.DATA_VERSION_KEYWORD)) {
                    OBOParser.this.data_version = new ByteString(buf, valueStart, valueStart + valueLen);
                } else if (this.equalsIgnoreCase(buf, keyStart, keyLen, OBOKeywords.SUBSETDEF_KEYWORD)) {
                    Subset s = Subset.createFromString((String)new String(buf, valueStart, valueLen));
                    if (!OBOParser.this.subsets.containsKey(s.getName())) {
                        OBOParser.this.subsets.put(s.getName(), s);
                    }
                }
            }

            private TermID readTermID(byte[] buf, int valueStart, int valueLen) {
                return (TermID)OBOParser.this.termIDPool.map((Object)new TermID(buf, valueStart, valueLen, OBOParser.this.prefixPool));
            }

            private int findUnescaped(byte[] buf, int start, int len, char c) {
                while (len > 0) {
                    if (buf[start] == 92) {
                        start += 2;
                        len -= 2;
                        continue;
                    }
                    if (buf[start] == c) {
                        return start;
                    }
                    ++start;
                    --len;
                }
                return -1;
            }

            private int findUnescaped(byte[] buf, int start, int len, char c1, char c2) {
                while (len != 0) {
                    if (buf[start] == c1 || buf[start] == c2) {
                        return start;
                    }
                    ++start;
                    --len;
                }
                return -1;
            }

            private int findUnescaped(byte[] buf, int start, int len, char c1, char c2, char c3) {
                while (len != 0) {
                    if (buf[start] == c1 || buf[start] == c2) {
                        return start;
                    }
                    ++start;
                    --len;
                }
                return -1;
            }

            private int skipSpaces(byte[] buf, int start, int len) {
                while (len != 0) {
                    if (buf[start] != 32 && buf[start] != 9) {
                        return start;
                    }
                    ++start;
                    --len;
                }
                return -1;
            }

            private void parse_id(byte[] buf, int valueStart, int valueLen) {
                OBOParser.this.currentID = this.readTermID(buf, valueStart, valueLen);
                if ((OBOParser.this.options & 8) != 0) {
                    OBOParser.this.currentName = OBOParser.this.currentID.toByteString();
                }
            }

            private void parse_name(byte[] buf, int valueStart, int valueLen) {
                OBOParser.this.currentName = new ByteString(buf, valueStart, valueStart + valueLen);
            }

            private void parse_is_a(byte[] buf, int valueStart, int valueLen) {
                OBOParser.this.currentParents.add(new ParentTermID(this.readTermID(buf, valueStart, valueLen), TermRelation.IS_A));
            }

            private void parse_relationship(byte[] buf, int valueStart, int valueLen) {
                int typeStart = valueStart;
                int typeEnd = this.findUnescaped(buf, valueStart, valueLen, ' ');
                if (typeEnd == -1) {
                    return;
                }
                int idStart = this.skipSpaces(buf, typeEnd, valueStart + valueLen - typeEnd);
                if (idStart == -1) {
                    return;
                }
                int idEnd = this.findUnescaped(buf, idStart, valueStart + valueLen - idStart, '[', ' ', '!');
                if (idEnd == -1) {
                    idEnd = valueStart + valueLen;
                }
                TermRelation type = this.equalsIgnoreCase(buf, typeStart, typeEnd - typeStart, OBOKeywords.PART_OF_KEYWORD) ? TermRelation.PART_OF_A : (this.equalsIgnoreCase(buf, typeStart, typeEnd - typeStart, OBOKeywords.REGULATES_KEYWORD) ? TermRelation.REGULATES : (this.equalsIgnoreCase(buf, typeStart, typeEnd - typeStart, OBOKeywords.NEGATIVELY_REGULATES_KEYWORD) ? TermRelation.POSITIVELY_REGULATES : (this.equalsIgnoreCase(buf, typeStart, typeEnd - typeStart, OBOKeywords.POSITIVELY_REGULATES_KEYWORD) ? TermRelation.NEGATIVELY_REGULATES : TermRelation.UNKOWN)));
                OBOParser.this.currentParents.add(new ParentTermID(this.readTermID(buf, idStart, idEnd - idStart + 1), type));
            }

            private void parse_synonym(byte[] buf, int valueStart, int valueLen) {
                if ((OBOParser.this.options & 0x10) == 0) {
                    int synonymEnd;
                    int synonymStart = this.findUnescaped(buf, valueStart, valueLen, '\"');
                    if (synonymStart == -1) {
                        return;
                    }
                    if ((synonymEnd = this.findUnescaped(buf, ++synonymStart, valueStart + valueLen - synonymStart, '\"')) == -1) {
                        return;
                    }
                    OBOParser.this.currentSynonyms.add(new ByteString(buf, synonymStart, synonymEnd));
                }
            }

            private void parse_def(byte[] buf, int valueStart, int valueLen) {
                if ((OBOParser.this.options & 1) != 0) {
                    int defEnd;
                    int defStart = this.findUnescaped(buf, valueStart, valueLen, '\"');
                    if (defStart == -1) {
                        return;
                    }
                    if ((defEnd = this.findUnescaped(buf, ++defStart, valueStart + valueLen - defStart, '\"')) == -1) {
                        return;
                    }
                    if (this.temp == null || this.temp.length < defEnd - defStart + 1) {
                        this.temp = new byte[defEnd - defStart + 1];
                    }
                    int len = 0;
                    for (int i = defStart; i < defEnd; ++i) {
                        if (buf[i] == 92) continue;
                        this.temp[len++] = buf[i];
                    }
                    OBOParser.this.currentDefintion = new ByteString(this.temp, 0, len);
                }
            }

            private void parse_namespace(byte[] buf, int valueStart, int valueLen) {
                ByteString newNamespace = new ByteString(buf, valueStart, valueStart + valueLen);
                Namespace namespace = (Namespace)OBOParser.this.namespaces.get(newNamespace);
                if (namespace == null) {
                    namespace = new Namespace(newNamespace);
                    OBOParser.this.namespaces.put(newNamespace, namespace);
                }
                OBOParser.this.currentNamespace = namespace;
            }

            private void parse_equivalent_to(byte[] buf, int valueStart, int valueLen) {
                OBOParser.this.currentEquivalents.add(this.readTermID(buf, valueStart, valueLen));
            }

            private void parse_is_obsolete(byte[] buf, int valueStart, int valueLen) {
                OBOParser.this.currentObsolete = this.equalsIgnoreCase(buf, valueStart, valueLen, OBOKeywords.TRUE_KEYWORD);
            }

            private void parse_alt_id(byte[] buf, int valueStart, int valueLen) {
                OBOParser.this.currentAlternatives.add(this.readTermID(buf, valueStart, valueLen));
            }

            private void parse_xref(byte[] buf, int valueStart, int valueLen) {
                if ((OBOParser.this.options & 2) != 0) {
                    String xrefName;
                    int dbStart = valueStart;
                    int dbEnd = this.findUnescaped(buf, valueStart, valueLen, ':');
                    if (dbEnd == -1) {
                        return;
                    }
                    int idStart = this.skipSpaces(buf, dbEnd + 1, valueStart + valueLen - dbEnd - 1);
                    if (idStart == -1) {
                        return;
                    }
                    int idEnd = valueStart + valueLen;
                    int nameStart = this.findUnescaped(buf, idStart + 1, valueStart + valueLen - idStart - 1, '\"');
                    if (nameStart != -1) {
                        int nameEnd = this.findUnescaped(buf, ++nameStart, valueStart + valueLen - nameStart, '\"');
                        for (idEnd = nameStart - 2; idEnd > idStart && buf[idEnd - 1] == 32; --idEnd) {
                        }
                        xrefName = new String(buf, nameStart, nameEnd - nameStart);
                    } else {
                        xrefName = null;
                    }
                    String xrefDb = new String(buf, dbStart, dbEnd - dbStart);
                    String xrefId = new String(buf, idStart, idEnd - idStart);
                    OBOParser.this.currentXrefs.add(new TermXref(xrefDb, xrefId, xrefName));
                }
            }

            private void parse_subset(byte[] buf, int valueStart, int valueLen) {
                Subset subset = (Subset)OBOParser.this.subsets.get(new ByteString(buf, valueStart, valueStart + valueLen));
                if (subset != null) {
                    OBOParser.this.currentSubsets.add(subset);
                }
            }

            private void readTermValue(byte[] buf, int keyStart, int keyLen, int valueStart, int valueLen) {
                if (this.equalsIgnoreCase(buf, keyStart, keyLen, OBOKeywords.ID_KEYWORD)) {
                    this.parse_id(buf, valueStart, valueLen);
                } else if (this.equalsIgnoreCase(buf, keyStart, keyLen, OBOKeywords.NAME_KEYWORD)) {
                    this.parse_name(buf, valueStart, valueLen);
                } else if (this.equalsIgnoreCase(buf, keyStart, keyLen, OBOKeywords.IS_A_KEYWORD)) {
                    this.parse_is_a(buf, valueStart, valueLen);
                } else if (this.equalsIgnoreCase(buf, keyStart, keyLen, OBOKeywords.RELATIONSHIP_KEYWORD)) {
                    this.parse_relationship(buf, valueStart, valueLen);
                } else if ((OBOParser.this.options & 0x10) == 0 && this.equalsIgnoreCase(buf, keyStart, keyLen, OBOKeywords.SYNONYM_KEYWORD)) {
                    this.parse_synonym(buf, valueStart, valueLen);
                } else if ((OBOParser.this.options & 1) != 0 && this.equalsIgnoreCase(buf, keyStart, keyLen, OBOKeywords.DEF_KEYWORD)) {
                    this.parse_def(buf, valueStart, valueLen);
                } else if (this.equalsIgnoreCase(buf, keyStart, keyLen, OBOKeywords.NAMESPACE_KEYWORD)) {
                    this.parse_namespace(buf, valueStart, valueLen);
                } else if (this.equalsIgnoreCase(buf, keyStart, keyLen, OBOKeywords.EQUIVALENT_TO_KEYWORD)) {
                    this.parse_equivalent_to(buf, valueStart, valueLen);
                } else if (this.equalsIgnoreCase(buf, keyStart, keyLen, OBOKeywords.IS_OBSOLETE_KEYWORD)) {
                    this.parse_is_obsolete(buf, valueStart, valueLen);
                } else if (this.equalsIgnoreCase(buf, keyStart, keyLen, OBOKeywords.ALT_ID_KEYWORD)) {
                    this.parse_alt_id(buf, valueStart, valueLen);
                } else if ((OBOParser.this.options & 2) != 0 && this.equalsIgnoreCase(buf, keyStart, keyLen, OBOKeywords.XREF_KEYWORD)) {
                    this.parse_xref(buf, valueStart, valueLen);
                } else if (this.equalsIgnoreCase(buf, keyStart, keyLen, OBOKeywords.SUBSET_KEYWORD)) {
                    this.parse_subset(buf, valueStart, valueLen);
                }
            }
        }
        OBOByteLineScanner obls = new OBOByteLineScanner(this.input.inputStream());
        obls.scan();
        this.enterNewTerm();
        if (progress != null) {
            progress.update(this.input.getSize(), obls.currentTerm);
        }
        if (obls.exception != null) {
            throw obls.exception;
        }
        this.input.close();
        long durationMillis = System.currentTimeMillis() - startMillis;
        logger.log(Level.INFO, "Got " + this.terms.size() + " terms and " + this.numberOfRelations + " relations in " + durationMillis + " ms");
        return this.getParseDiagnostics();
    }

    public ByteString getFormatVersion() {
        return this.format_version;
    }

    public ByteString getDate() {
        return this.date;
    }

    public ByteString getDataVersion() {
        return this.data_version;
    }

    private String getParseDiagnostics() {
        StringBuilder diag = new StringBuilder();
        diag.append("Details of parsed obo file:\n");
        diag.append("  date:\t\t\t" + this.date + "\n");
        diag.append("  format:\t\t" + this.format_version + "\n");
        diag.append("  term definitions:\t" + this.terms.size());
        return diag.toString();
    }

    static {
        escapeChars.put(new Character(':'), new Character(':'));
        escapeChars.put(new Character('W'), new Character(' '));
        escapeChars.put(new Character('t'), new Character('\t'));
        escapeChars.put(new Character(','), new Character(','));
        escapeChars.put(new Character('\"'), new Character('\"'));
        escapeChars.put(new Character('n'), new Character('\n'));
        escapeChars.put(new Character('\\'), new Character('\\'));
        escapeChars.put(new Character('{'), new Character('{'));
        escapeChars.put(new Character('}'), new Character('}'));
        escapeChars.put(new Character('['), new Character('['));
        escapeChars.put(new Character(']'), new Character(']'));
        escapeChars.put(new Character('!'), new Character('!'));
        for (Character key : escapeChars.keySet()) {
            Character value = escapeChars.get(key);
            unescapeChars.put(value, key);
        }
    }

    private static enum Stanza {
        TERM,
        TYPEDEF;

    }
}

