/*
 * Decompiled with CFR 0.152.
 */
package ontologizer.io.obo;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.zip.GZIPInputStream;
import ontologizer.io.obo.IParserInput;

public class OBOParserFileInput
implements IParserInput {
    private String filename;
    private FileInputStream fis;
    private InputStream is;
    private FileChannel fc;

    public OBOParserFileInput(String filename) throws IOException {
        this.filename = filename;
        this.fis = new FileInputStream(filename);
        try {
            this.is = new GZIPInputStream(this.fis);
        }
        catch (IOException exp) {
            this.fis.close();
            this.fis = new FileInputStream(filename);
            this.is = this.fis;
        }
        this.fc = this.fis.getChannel();
    }

    @Override
    public InputStream inputStream() {
        return this.is;
    }

    @Override
    public void close() {
        try {
            this.fis.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int getSize() {
        try {
            return (int)this.fc.size();
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    @Override
    public int getPosition() {
        try {
            return (int)this.fc.position();
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    @Override
    public String getFilename() {
        return this.filename;
    }
}

