/*
 * Decompiled with CFR 0.152.
 */
package okw.gui.adapter.selenium;

import java.util.List;
import okw.OKW_Helper;
import okw.exceptions.OKWGUIObjectNotFoundException;
import okw.log.Logger_Sngltn;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;

public class SeDriver {
    protected Logger_Sngltn MyLogger = Logger_Sngltn.getInstance();
    public WebDriver driver;
    String currentIframeID = "";
    private static SeDriver instance = new SeDriver();

    private SeDriver() {
    }

    public static SeDriver getInstance() {
        return instance;
    }

    public void DriveChrome() {
        this.driver = new ChromeDriver();
    }

    public void DriveFireFox() {
        this.driver = new FirefoxDriver();
    }

    public void DriveUnitDriver() {
        try {
            this.driver = new HtmlUnitDriver(true);
        }
        catch (Exception e) {
            System.out.println(e.getStackTrace());
        }
    }

    public void swichToFrame(String iframeID) {
        if (!this.currentIframeID.equalsIgnoreCase(iframeID)) {
            this.driver.switchTo().defaultContent();
            if (!OKW_Helper.isStringNullOrEmpty((String)iframeID).booleanValue()) {
                try {
                    this.driver.switchTo().frame(iframeID);
                    this.currentIframeID = iframeID;
                }
                catch (NoSuchFrameException e) {
                    System.out.println("Unable to locate frame with id " + iframeID + e.getStackTrace());
                }
                catch (Exception e) {
                    System.out.println("Unable to navigate to frame with id " + iframeID + e.getStackTrace());
                }
            }
        }
    }

    public WebElement getElement(String frameID, String Locator) {
        WebElement me = null;
        List meme = null;
        this.swichToFrame(frameID);
        meme = this.driver.findElements(By.xpath((String)Locator));
        if (meme.size() == 0) {
            String lvsPrintMe = "GUI-Objekt wurde nicht gefunden: Locator: >>" + Locator + "<<";
            this.MyLogger.LogPrint("????????????????????????????????????????????????????????????");
            this.MyLogger.LogPrint(lvsPrintMe);
            this.MyLogger.LogPrint("????????????????????????????????????????????????????????????");
            throw new OKWGUIObjectNotFoundException(lvsPrintMe);
        }
        if (meme.size() > 1) {
            String lvsPrintMe = "Locator ist nicht eindeutig, es wurden mehrer GUI-Objekt gefunden:\n Locator: >>" + Locator + "<<";
            this.MyLogger.LogPrint("????????????????????????????????????????????????????????????");
            this.MyLogger.LogPrint(lvsPrintMe);
            this.MyLogger.LogPrint("????????????????????????????????????????????????????????????");
            throw new OKWGUIObjectNotFoundException(lvsPrintMe);
        }
        me = (WebElement)meme.get(0);
        return me;
    }

    public List<WebElement> getElements(String frameID, String fpsLocator) {
        List meme = null;
        this.swichToFrame(frameID);
        meme = this.driver.findElements(By.xpath((String)fpsLocator));
        return meme;
    }
}

