/*
 * Decompiled with CFR 0.152.
 */
package okw.gui.adapter.selenium.webdriver;

import java.util.ArrayList;
import java.util.List;
import okw.OKW_Helper;
import okw.exceptions.OKWGUIObjectNotFoundException;
import okw.exceptions.OKWGUIObjectNotUniqueException;
import okw.log.Logger_Sngltn;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;

public class SeDriver {
    protected Logger_Sngltn MyLogger = Logger_Sngltn.getInstance();
    private WebDriver driver = null;
    private String currentiframeID = "";
    private static SeDriver instance = new SeDriver();

    public String getCurrentiframeID() {
        return this.currentiframeID;
    }

    private SeDriver() {
    }

    public static SeDriver getInstance() {
        return instance;
    }

    public void setDriver(WebDriver fpDriver) {
        this.driver = fpDriver;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public void __DriveChrome() {
        this.driver = new ChromeDriver();
    }

    public void __DriveFireFox() {
        this.driver = new FirefoxDriver();
    }

    public void __DriveUnitDriver() {
        try {
            this.driver = new HtmlUnitDriver(true);
        }
        catch (Exception e) {
            System.out.println(e.getStackTrace());
        }
    }

    public void swichToFrame(String iframeID) {
        this.driver.switchTo().defaultContent();
        if (!OKW_Helper.isStringNullOrEmpty((String)iframeID).booleanValue()) {
            try {
                this.driver.switchTo().frame(iframeID);
            }
            catch (NoSuchFrameException e) {
                System.out.println("Unable to locate frame with id " + iframeID + e.getStackTrace());
            }
            catch (Exception e) {
                System.out.println("Unable to navigate to frame with id " + iframeID + e.getStackTrace());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement getWebElement(String fpsLocator) {
        WebElement myWebElement = null;
        ArrayList<String> iframeIDs = new ArrayList<String>();
        ArrayList<WebElement> WebElements = new ArrayList<WebElement>();
        boolean isRoot = "/*".equals(fpsLocator);
        try {
            this.MyLogger.LogFunctionStartDebug("SeDriver.getWebElement", new String[]{"fpsLocator", fpsLocator});
            this.MyLogger.LogPrint("Locator" + fpsLocator);
            if (isRoot) {
                this.MyLogger.LogPrint("root");
                iframeIDs.add("");
            } else {
                this.MyLogger.LogPrint("no root");
                iframeIDs.addAll(this.getIframesID());
            }
            this.MyLogger.LogPrintDebug("Number of iFrames found: " + Integer.valueOf(iframeIDs.size()).toString());
            for (String iframeID : iframeIDs) {
                try {
                    myWebElement = this.getWebElement(iframeID, fpsLocator);
                    if (myWebElement == null) continue;
                    WebElements.add(myWebElement);
                    this.currentiframeID = iframeID;
                }
                catch (OKWGUIObjectNotFoundException e) {}
            }
            if (WebElements.size() == 0) {
                throw new OKWGUIObjectNotFoundException("GUI object was not found. Locator: \"" + fpsLocator + "\"");
            }
            if (WebElements.size() > 1) {
                throw new OKWGUIObjectNotUniqueException("Object was not uniquely found. Several objects match the locator: \"" + fpsLocator + "\"");
            }
            this.swichToFrame(this.currentiframeID);
        }
        finally {
            this.MyLogger.LogFunctionEndDebug();
        }
        return (WebElement)WebElements.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<String> getIframesID() {
        ArrayList<String> lvReturn = new ArrayList<String>();
        lvReturn.add("");
        this.MyLogger.LogFunctionStartDebug("SeDriver.getIframesID", new String[0]);
        try {
            this.swichToFrame("");
            List iframes = this.driver.findElements(By.tagName((String)"iframe"));
            this.MyLogger.ResOpenListDebug("iFrames...");
            try {
                for (WebElement iframe : iframes) {
                    String myID = iframe.getAttribute("id");
                    if (!OKW_Helper.isStringNullOrEmpty((String)myID).booleanValue()) {
                        lvReturn.add(myID);
                        this.MyLogger.LogPrintDebug("ID='" + myID + "'");
                        continue;
                    }
                    myID = iframe.getAttribute("name");
                    if (!OKW_Helper.isStringNullOrEmpty((String)myID).booleanValue()) {
                        lvReturn.add(myID);
                        this.MyLogger.LogPrintDebug("name='" + myID + "'");
                        continue;
                    }
                    this.MyLogger.LogWarning("iFrame has neither ID nor Name:" + iframe.toString());
                }
            }
            finally {
                this.MyLogger.ResCloseListDebug();
            }
        }
        finally {
            this.MyLogger.LogFunctionEndDebug(lvReturn);
        }
        return lvReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebElement getWebElement(String fpsFrameID, String fpsLocator) {
        Object webElement = null;
        List webElements = null;
        try {
            this.MyLogger.LogFunctionStartDebug("SeDriver.getWebElement", new String[]{"fpsFrameID", fpsFrameID, "fpsLocator", fpsLocator});
            this.swichToFrame(fpsFrameID);
            webElements = this.driver.findElements(By.xpath((String)fpsLocator));
            if (webElements.size() == 0) {
                String lvsPrintMe = "GUI object was not found. Locator: \"" + fpsLocator + "\"";
                this.MyLogger.LogPrintDebug(lvsPrintMe);
                throw new OKWGUIObjectNotFoundException(lvsPrintMe);
            }
            if (webElements.size() > 1) {
                String lvsPrintMe = "Object was not uniquely found. Several objects match the locator: \"" + fpsLocator + "\"";
                this.MyLogger.LogWarning(lvsPrintMe);
                throw new OKWGUIObjectNotUniqueException(lvsPrintMe);
            }
            String lvsPrintMe = "GUI object was found. iframe: '" + fpsFrameID + "' Locator: '" + fpsLocator + "'";
            this.MyLogger.LogPrintDebug(lvsPrintMe);
            webElement = (WebElement)webElements.get(0);
        }
        finally {
            if (webElement != null) {
                this.MyLogger.LogFunctionEndDebug(webElement.toString());
            } else {
                this.MyLogger.LogFunctionEndDebug();
            }
        }
        return webElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<WebElement> __getWebElements(String fpsFrameID, String fpsLocator) {
        List WebElements = null;
        try {
            this.MyLogger.LogFunctionStartDebug("SeDriver.getElement", new String[]{"fpsFrameID", fpsFrameID, "fpsLocator", fpsLocator});
            this.swichToFrame(fpsFrameID);
            WebElements = this.driver.findElements(By.xpath((String)fpsLocator));
        }
        finally {
            this.MyLogger.LogFunctionEndDebug();
        }
        return WebElements;
    }
}

