/*
 * Decompiled with CFR 0.152.
 */
package okw.gui.adapter.selenium.webdriver;

import java.util.ArrayList;
import java.util.List;
import okw.OKW_Helper;
import okw.exceptions.OKWGUIObjectNotFoundException;
import okw.exceptions.OKWGUIObjectNotUniqueException;
import okw.log.Logger_Sngltn;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;

public class SeDriver {
    protected Logger_Sngltn LOG = Logger_Sngltn.getInstance();
    private WebDriver driver = null;
    private String currentiframeID = "";
    private static SeDriver instance = new SeDriver();

    public String getCurrentiframeID() {
        return this.currentiframeID;
    }

    private SeDriver() {
    }

    public static SeDriver getInstance() {
        return instance;
    }

    public void setDriver(WebDriver fpDriver) {
        this.driver = fpDriver;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public void __DriveChrome() {
        this.driver = new ChromeDriver();
    }

    public void __DriveFireFox() {
        this.driver = new FirefoxDriver();
    }

    public void __DriveUnitDriver() {
        try {
            this.driver = new HtmlUnitDriver(true);
        }
        catch (Exception e) {
            System.out.println(e.getStackTrace());
        }
    }

    public void swichToFrame(String iframeID) {
        block7: {
            this.LOG.LogFunctionStartDebug("SeDriver.swichToFrame", new String[]{"String iframeID", iframeID});
            try {
                this.driver.switchTo().defaultContent();
                this.LOG.LogPrintDebug("Reset switch to: defaultContent");
                if (!OKW_Helper.isStringNullOrEmpty((String)iframeID).booleanValue()) {
                    try {
                        this.driver.switchTo().frame(iframeID);
                        this.LOG.LogPrintDebug("Switch to iFrame:" + iframeID);
                        break block7;
                    }
                    catch (NoSuchFrameException e) {
                        this.LOG.LogWarning("Unable to locate frame with id " + iframeID);
                        this.LOG.LogPrint("Stack Trace: " + e.getStackTrace());
                        throw e;
                    }
                    catch (Exception e) {
                        this.LOG.LogWarning("Unable to set Conext to iFrame with id " + iframeID);
                        this.LOG.LogPrint("Stack Trace: " + e.getStackTrace());
                        throw e;
                    }
                }
                this.LOG.LogPrintDebug("iframeID is Empty or Null");
                this.LOG.LogPrintDebug("We stay on the defaultContent.");
            }
            finally {
                this.LOG.LogFunctionEndDebug();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement getWebElement(String fpsLocator) {
        WebElement myWebElement = null;
        ArrayList<String> iframeIDs = new ArrayList<String>();
        ArrayList<WebElement> WebElements = new ArrayList<WebElement>();
        boolean isRoot = "/*".equals(fpsLocator);
        try {
            this.LOG.LogFunctionStartDebug("SeDriver.getWebElement", new String[]{"fpsLocator", fpsLocator});
            this.LOG.LogPrint("Locator" + fpsLocator);
            if (isRoot) {
                this.LOG.LogPrint("root");
                iframeIDs.add("");
            } else {
                this.LOG.LogPrint("no root");
                iframeIDs.addAll(this.getIframesID());
            }
            this.LOG.LogPrintDebug("Number of iFrames found: " + Integer.valueOf(iframeIDs.size()).toString());
            for (String iframeID : iframeIDs) {
                try {
                    myWebElement = this.getWebElement(iframeID, fpsLocator);
                    if (myWebElement == null) continue;
                    WebElements.add(myWebElement);
                    this.currentiframeID = iframeID;
                }
                catch (OKWGUIObjectNotFoundException | NoSuchFrameException e) {}
            }
            if (WebElements.size() == 0) {
                throw new OKWGUIObjectNotFoundException("GUI object was not found. Locator: \"" + fpsLocator + "\"");
            }
            if (WebElements.size() > 1) {
                throw new OKWGUIObjectNotUniqueException("Object was not uniquely found. Several objects match the locator: \"" + fpsLocator + "\"");
            }
            this.swichToFrame(this.currentiframeID);
        }
        finally {
            this.LOG.LogFunctionEndDebug();
        }
        return (WebElement)WebElements.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<String> getIframesID() {
        ArrayList<String> lvReturn = new ArrayList<String>();
        lvReturn.add("");
        this.LOG.LogFunctionStartDebug("SeDriver.getIframesID", new String[0]);
        try {
            this.swichToFrame("");
            List iframes = this.driver.findElements(By.tagName((String)"iframe"));
            this.LOG.ResOpenListDebug("iFrames...");
            try {
                for (WebElement iframe : iframes) {
                    String myID = iframe.getAttribute("id");
                    if (!OKW_Helper.isStringNullOrEmpty((String)myID).booleanValue()) {
                        lvReturn.add(myID);
                        this.LOG.LogPrintDebug("ID='" + myID + "'");
                        continue;
                    }
                    myID = iframe.getAttribute("name");
                    if (!OKW_Helper.isStringNullOrEmpty((String)myID).booleanValue()) {
                        lvReturn.add(myID);
                        this.LOG.LogPrintDebug("name='" + myID + "'");
                        continue;
                    }
                    this.LOG.LogWarning("iFrame has neither ID nor Name:" + iframe.toString());
                }
            }
            finally {
                this.LOG.ResCloseListDebug();
            }
        }
        finally {
            this.LOG.LogFunctionEndDebug(lvReturn);
        }
        return lvReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebElement getWebElement(String fpsFrameID, String fpsLocator) {
        Object webElement = null;
        List webElements = null;
        try {
            this.LOG.LogFunctionStartDebug("SeDriver.getWebElement", new String[]{"fpsFrameID", fpsFrameID, "fpsLocator", fpsLocator});
            this.swichToFrame(fpsFrameID);
            webElements = this.driver.findElements(By.xpath((String)fpsLocator));
            if (webElements.size() == 0) {
                String lvsPrintMe = "GUI object was not found. Locator: \"" + fpsLocator + "\"";
                this.LOG.LogPrintDebug(lvsPrintMe);
                throw new OKWGUIObjectNotFoundException(lvsPrintMe);
            }
            if (webElements.size() > 1) {
                String lvsPrintMe = "Object was not uniquely found. Several objects match the locator: \"" + fpsLocator + "\"";
                this.LOG.LogWarning(lvsPrintMe);
                throw new OKWGUIObjectNotUniqueException(lvsPrintMe);
            }
            String lvsPrintMe = "GUI object was found. iframe: '" + fpsFrameID + "' Locator: '" + fpsLocator + "'";
            this.LOG.LogPrintDebug(lvsPrintMe);
            webElement = (WebElement)webElements.get(0);
        }
        finally {
            if (webElement != null) {
                this.LOG.LogFunctionEndDebug(webElement.toString());
            } else {
                this.LOG.LogFunctionEndDebug();
            }
        }
        return webElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<WebElement> __getWebElements(String fpsFrameID, String fpsLocator) {
        List WebElements = null;
        try {
            this.LOG.LogFunctionStartDebug("SeDriver.getElement", new String[]{"fpsFrameID", fpsFrameID, "fpsLocator", fpsLocator});
            this.swichToFrame(fpsFrameID);
            WebElements = this.driver.findElements(By.xpath((String)fpsLocator));
        }
        finally {
            this.LOG.LogFunctionEndDebug();
        }
        return WebElements;
    }
}

