/*
 * Decompiled with CFR 0.152.
 */
package okw.gui.adapter.selenium;

import java.util.ArrayList;
import okw.OKW;
import okw.OKW_Const_Sngltn;
import okw.exceptions.OKWGUIObjectNotFoundException;
import okw.exceptions.OKWNotAllowedValueException;
import okw.exceptions.OKWOnlySingleValueAllowedException;
import okw.gui.OKWLocatorBase;
import okw.gui.adapter.selenium.SeAnyChildWindow;
import okw.gui.adapter.selenium.SeAriaRadio;
import okw.gui.adapter.selenium.webdriver.SeDriver;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class SeAriaRadioGroup
extends SeAnyChildWindow {
    @OKW(FN="RadioButon", VerifyLabel_PT=500, VerifyLabel_TO=5, VerifyIsActive_PT=500, VerifyIsActive_TO=1, VerifyValue_PT=500, VerifyValue_TO=5, VerifyTooltip_PT=500, VerifyTooltip_TO=5, VerifyCaption_PT=500, VerifyCaption_TO=5, VerifyExists_PT=500, VerifyExists_TO=5, VerifyHasFocus_PT=500, VerifyHasFocus_TO=5)
    public SeAriaRadio myRadiobutton = new SeAriaRadio("", new OKWLocatorBase[0]);

    public SeAriaRadioGroup(String Locator, OKWLocatorBase ... Locators) {
        super(Locator, Locators);
    }

    @Override
    public void SetValue(ArrayList<String> Val) {
        String myLocator = "";
        if (Val.size() == 1) {
            String DELETE = OKW_Const_Sngltn.getInstance().GetOKWConst4Internalname("DELETE");
            if (Val.get(0).equals(DELETE)) {
                throw new OKWNotAllowedValueException("SeAriaRadioList: This Value is not Alowed here: " + Val.get(0));
            }
        } else {
            throw new OKWOnlySingleValueAllowedException("SeAriaRadioList: Only single value is allowed!");
        }
        myLocator = "$L1$//*[normalize-space(text() )= '" + Val.get(0).trim() + "']";
        this.LogPrint("[SeAriaRadioGrout] SetValue: Calculated locator: '" + myLocator + "'");
        this.myRadiobutton.setLocator(myLocator, new OKWLocatorBase[]{this.getLOCATOR()});
        this.myRadiobutton.ClickOn();
    }

    @Override
    public void Select(ArrayList<String> Val) {
        this.SetValue(Val);
    }

    @Override
    public ArrayList<String> getValue() {
        ArrayList<String> lvLsReturn = new ArrayList<String>();
        try {
            this.myRadiobutton.setLocator("$L1$//*[@role=\"radio\" and @aria-checked=\"true\" ]", new OKWLocatorBase[]{this.getLOCATOR()});
            lvLsReturn = this.myRadiobutton.getCaption();
        }
        catch (OKWGUIObjectNotFoundException e) {
            lvLsReturn.add("");
        }
        return lvLsReturn;
    }

    @Override
    public ArrayList<String> getLabel() {
        ArrayList<String> lvLsReturn = new ArrayList<String>();
        String aria_labelledby = this.getAttribute("aria-labelledby").get(0);
        WebElement label = SeDriver.getInstance().getDriver().findElement(By.xpath((String)(this.getLocator() + "//*[@id = '" + aria_labelledby + "']")));
        String myAttribute = this.WaitForInteractionReturnString(() -> label.getAttribute("textContent"));
        myAttribute = StringUtils.normalizeSpace((String)myAttribute);
        lvLsReturn.add(myAttribute);
        return lvLsReturn;
    }
}

