/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.samples;

import de.osci.osci12.samples.StreamChunker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class ChunkHelper {
    private ArrayList<File> chunks;
    private boolean chunksDeleted = false;
    private long chunkSizeBytes;

    public ChunkHelper(InputStream in, String chunkDirectory, String chunkName, long chunkSize) throws IOException {
        this.chunkSizeBytes = chunkSize * 1024L;
        this.chunks = new ArrayList((int)((long)in.available() / this.chunkSizeBytes + 1L));
        this.writeToFiles(in, chunkDirectory + File.separator + chunkName, this.chunkSizeBytes);
    }

    public ChunkHelper(InputStream in, String chunkDirectory, String chunkName, int chunkNumber, long totalSize, Mode mode) throws IOException {
        this.chunks = new ArrayList(chunkNumber);
        this.writeToFiles(in, chunkDirectory + File.separator + chunkName, chunkNumber, totalSize * 1024L, mode);
    }

    public int getNumberOfChunks() {
        return this.chunks.size();
    }

    public File getChunkFile(int num) {
        if (!this.chunksDeleted && num <= this.chunks.size() && num > 0) {
            return this.chunks.get(num - 1);
        }
        return null;
    }

    public ArrayList<File> getChunkFiles() {
        return this.chunks;
    }

    public FileInputStream getChunk(int num) throws FileNotFoundException {
        if (!this.chunksDeleted && num <= this.chunks.size() && num > 0) {
            return new FileInputStream(this.chunks.get(num - 1));
        }
        return null;
    }

    public long getChunkSize() {
        return this.chunkSizeBytes / 1024L;
    }

    public void deleteFiles() {
        if (!this.chunksDeleted) {
            for (File file : this.chunks) {
                file.delete();
            }
            this.chunksDeleted = true;
            this.chunks = null;
        }
    }

    private void writeToFiles(InputStream in, String filePath, long chunkSize) throws IOException {
        try (StreamChunker ss = new StreamChunker(in);){
            String fileName = filePath + ".chunk";
            int i = 1;
            while (ss.chunkRemaining()) {
                File file = new File(fileName + i);
                try (FileOutputStream out = new FileOutputStream(file);){
                    ss.writeChunk(out, chunkSize);
                }
                this.chunks.add(file);
                ++i;
            }
        }
    }

    private long writeToFiles(InputStream in, String filePath, int chunkNumber, long totalSize, Mode mode) throws IOException {
        this.chunkSizeBytes = totalSize / (long)chunkNumber + 128L;
        if (mode == Mode.OPTIMIZEDSTORE) {
            this.chunkSizeBytes = (totalSize - this.chunkSizeBytes / 3L) / (long)(chunkNumber - 1);
        }
        this.writeToFiles(in, filePath, this.chunkSizeBytes);
        return this.chunkSizeBytes;
    }

    public static enum Mode {
        CONSTANTSIZE,
        OPTIMIZEDSTORE;

    }
}

