/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.samples;

import de.osci.helper.Tools;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.extinterfaces.TransportI;
import de.osci.osci12.extinterfaces.crypto.Decrypter;
import de.osci.osci12.extinterfaces.crypto.Signer;
import de.osci.osci12.messageparts.Attachment;
import de.osci.osci12.messageparts.Content;
import de.osci.osci12.messageparts.ContentContainer;
import de.osci.osci12.messageparts.EncryptedDataOSCI;
import de.osci.osci12.messagetypes.ExitDialog;
import de.osci.osci12.messagetypes.FetchDelivery;
import de.osci.osci12.messagetypes.FetchProcessCard;
import de.osci.osci12.messagetypes.GetMessageId;
import de.osci.osci12.messagetypes.InitDialog;
import de.osci.osci12.messagetypes.ResponseToExitDialog;
import de.osci.osci12.messagetypes.ResponseToFetchDelivery;
import de.osci.osci12.messagetypes.ResponseToFetchProcessCard;
import de.osci.osci12.messagetypes.ResponseToGetMessageId;
import de.osci.osci12.messagetypes.ResponseToInitDialog;
import de.osci.osci12.messagetypes.ResponseToStoreDelivery;
import de.osci.osci12.messagetypes.StoreDelivery;
import de.osci.osci12.roles.Addressee;
import de.osci.osci12.roles.Intermed;
import de.osci.osci12.roles.Originator;
import de.osci.osci12.roles.Reader;
import de.osci.osci12.roles.Role;
import de.osci.osci12.samples.impl.HttpTransport;
import de.osci.osci12.samples.impl.crypto.PKCS12Decrypter;
import de.osci.osci12.samples.impl.crypto.PKCS12Signer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class OneWayMessage_ActiveRecipient {
    Intermed intermed;

    public OneWayMessage_ActiveRecipient(String intermedURL) throws CertificateException, URISyntaxException {
        X509Certificate intermedCipherCert = Tools.createCertificate((InputStream)this.getClass().getResourceAsStream("/de/osci/osci12/samples/zertifikate/osci_manager_cipher_4096.cer"));
        this.intermed = new Intermed(null, intermedCipherCert, new URI(intermedURL));
    }

    public ResponseToStoreDelivery sendStoreDelivery() throws GeneralSecurityException, IOException, OSCIException {
        Originator user_1 = new Originator((Signer)new PKCS12Signer("/de/osci/osci12/samples/zertifikate/alice_signature_4096.p12", "123456"), (Decrypter)new PKCS12Decrypter("/de/osci/osci12/samples/zertifikate/carol_cipher_4096.p12", "123456"));
        DialogHandler clientDialog = new DialogHandler(user_1, this.intermed, (TransportI)new HttpTransport());
        GetMessageId getMsgID = new GetMessageId(clientDialog);
        ResponseToGetMessageId rsp2GetMsgID = getMsgID.send();
        if (!rsp2GetMsgID.getFeedback()[0][1].startsWith("0")) {
            // empty if block
        }
        Addressee user_2 = new Addressee(null, Tools.createCertificate((InputStream)this.getClass().getResourceAsStream("/de/osci/osci12/samples/zertifikate/bob_cipher_4096.cer")));
        StoreDelivery storeDel = new StoreDelivery(clientDialog, user_2, rsp2GetMsgID.getMessageId());
        storeDel.setSubject("Subject");
        ContentContainer not_encrypted_container = new ContentContainer();
        not_encrypted_container.addContent(new Content("Any content data."));
        not_encrypted_container.addContent(new Content(new Attachment((InputStream)new ByteArrayInputStream("Any unencrypted attachment data.".getBytes()), "test.txt")));
        not_encrypted_container.sign((Role)user_1);
        storeDel.addContentContainer(not_encrypted_container);
        Reader reader = new Reader(Tools.createCertificate((InputStream)this.getClass().getResourceAsStream("/de/osci/osci12/samples/zertifikate/dave_cipher_4096.cer")));
        ContentContainer encrypted_container = new ContentContainer();
        encrypted_container.addContent(new Content("Any encrypted content data."));
        encrypted_container.addContent(new Content(new Attachment((InputStream)new ByteArrayInputStream("Any encrypted attachment data.".getBytes()), "enc_test.txt", "http://www.w3.org/2009/xmlenc11#aes256-gcm")));
        EncryptedDataOSCI encryptedData = new EncryptedDataOSCI("http://www.w3.org/2009/xmlenc11#aes256-gcm", encrypted_container);
        encryptedData.encrypt((Role)reader);
        storeDel.addEncryptedData(encryptedData);
        ResponseToStoreDelivery rsp2StoreDel = storeDel.send();
        if (!rsp2StoreDel.getFeedback()[0][1].startsWith("0")) {
            // empty if block
        }
        rsp2StoreDel.getInspections();
        rsp2StoreDel.getTimestampCreation();
        rsp2StoreDel.getRecentModification();
        return rsp2StoreDel;
    }

    public ResponseToFetchDelivery sendFetchDelivery(String messageId) throws GeneralSecurityException, IOException, OSCIException {
        Originator user_2 = new Originator((Signer)new PKCS12Signer("/de/osci/osci12/samples/zertifikate/bob_signature_4096.p12", "123456"), (Decrypter)new PKCS12Decrypter("/de/osci/osci12/samples/zertifikate/bob_cipher_4096.p12", "123456"));
        DialogHandler clientDialog = new DialogHandler(user_2, this.intermed, (TransportI)new HttpTransport());
        InitDialog id = new InitDialog(clientDialog);
        ResponseToInitDialog rsp2InitDialog = id.send();
        if (!rsp2InitDialog.getFeedback()[0][1].startsWith("0")) {
            // empty if block
        }
        FetchDelivery fetchDel = new FetchDelivery(clientDialog);
        fetchDel.setSelectionMode(0);
        fetchDel.setSelectionRule(messageId);
        ResponseToFetchDelivery rsp2FetchDel = fetchDel.send();
        if (!rsp2FetchDel.getFeedback()[0][1].startsWith("0")) {
            // empty if block
        }
        ExitDialog ed = new ExitDialog(clientDialog);
        ResponseToExitDialog rsp2ExitDialog = ed.send();
        return rsp2FetchDel;
    }

    public ResponseToFetchProcessCard sendFetchProcessCard(String messageId) throws GeneralSecurityException, IOException, OSCIException {
        Originator user_1 = new Originator((Signer)new PKCS12Signer("/de/osci/osci12/samples/zertifikate/alice_signature_4096.p12", "123456"), (Decrypter)new PKCS12Decrypter("/de/osci/osci12/samples/zertifikate/carol_cipher_4096.p12", "123456"));
        DialogHandler clientDialog = new DialogHandler(user_1, this.intermed, (TransportI)new HttpTransport());
        InitDialog id = new InitDialog(clientDialog);
        ResponseToInitDialog rsp2InitDialog = id.send();
        if (!rsp2InitDialog.getFeedback()[0][1].startsWith("0")) {
            // empty if block
        }
        FetchProcessCard fetchProcCard = new FetchProcessCard(clientDialog);
        fetchProcCard.setSelectionMode(0);
        fetchProcCard.setSelectionRule(messageId);
        ResponseToFetchProcessCard rsp2FetchProcCard = fetchProcCard.send();
        if (!rsp2FetchProcCard.getFeedback()[0][1].startsWith("0")) {
            // empty if block
        }
        rsp2FetchProcCard.getProcessCardBundles();
        ExitDialog ed = new ExitDialog(clientDialog);
        ResponseToExitDialog rsp2ExitDialog = ed.send();
        return rsp2FetchProcCard;
    }

    public static void main(String[] args) {
        try {
            int i;
            String intermedUrl = args.length > 0 && args[0] != null ? args[0] : "http://gov.test.osci.de/osci-manager-entry/externalentry";
            OneWayMessage_ActiveRecipient scenario_1 = new OneWayMessage_ActiveRecipient(intermedUrl);
            ResponseToStoreDelivery responseStore = scenario_1.sendStoreDelivery();
            System.out.println("\nResponseToStoreDelivery:\n" + responseStore.toString());
            ResponseToFetchDelivery responseFetchDel = scenario_1.sendFetchDelivery(responseStore.getMessageId());
            Reader reader = new Reader((Decrypter)new PKCS12Decrypter("/de/osci/osci12/samples/zertifikate/dave_cipher_4096.p12", "123456"));
            System.out.println("\nResponseToFetchDelivery:\n" + responseFetchDel.toString());
            ResponseToFetchProcessCard responseFetchProcCard = scenario_1.sendFetchProcessCard(responseStore.getMessageId());
            System.out.println("\nResponseToFetchProcessCard:\n" + responseFetchProcCard.toString());
            System.out.println("\nCONTENT DATA:\n" + responseFetchDel.getContentContainer()[0].getContents()[0].getContentData());
            InputStream in = responseFetchDel.getContentContainer()[0].getContents()[1].getAttachment().getStream();
            StringBuffer attachment = new StringBuffer();
            while ((i = in.read()) > -1) {
                attachment.append((char)i);
            }
            in.close();
            System.out.println("\nATTACHMENT:\n" + attachment);
            System.out.println("\nRESULT OF SIGNATURE CHECK: " + responseFetchDel.getContentContainer()[0].checkAllSignatures());
            System.out.println("\nENCRYPTED CONTENT DATA:\n" + responseFetchDel.getEncryptedData()[0].decrypt((Role)reader).getContents()[0].getContentData());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

