/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.samples;

import de.osci.helper.Tools;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.extinterfaces.TransportI;
import de.osci.osci12.extinterfaces.crypto.Decrypter;
import de.osci.osci12.extinterfaces.crypto.Signer;
import de.osci.osci12.messageparts.Attachment;
import de.osci.osci12.messageparts.Content;
import de.osci.osci12.messageparts.ContentContainer;
import de.osci.osci12.messagetypes.ForwardDelivery;
import de.osci.osci12.messagetypes.GetMessageId;
import de.osci.osci12.messagetypes.ResponseToForwardDelivery;
import de.osci.osci12.messagetypes.ResponseToGetMessageId;
import de.osci.osci12.roles.Addressee;
import de.osci.osci12.roles.Intermed;
import de.osci.osci12.roles.Originator;
import de.osci.osci12.samples.impl.HttpTransport;
import de.osci.osci12.samples.impl.crypto.PKCS12Decrypter;
import de.osci.osci12.samples.impl.crypto.PKCS12Signer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;

public class OneWayMessage_PassiveRecipient {
    Intermed intermed;

    public OneWayMessage_PassiveRecipient(String intermedURL) throws Exception {
        X509Certificate intermedCipherCert = Tools.createCertificate((InputStream)this.getClass().getResourceAsStream("/de/osci/osci12/samples/zertifikate/osci_manager_cipher_4096.cer"));
        this.intermed = new Intermed(null, intermedCipherCert, new URI(intermedURL));
    }

    public ResponseToForwardDelivery sendForwardDelivery(String urlRecipient) throws GeneralSecurityException, IOException, OSCIException, URISyntaxException {
        Originator user_1 = new Originator((Signer)new PKCS12Signer("/de/osci/osci12/samples/zertifikate/alice_signature_4096.p12", "123456"), (Decrypter)new PKCS12Decrypter("/de/osci/osci12/samples/zertifikate/carol_cipher_4096.p12", "123456"));
        DialogHandler clientDialog = new DialogHandler(user_1, this.intermed, (TransportI)new HttpTransport());
        GetMessageId getMsgID = new GetMessageId(clientDialog);
        ResponseToGetMessageId rsp2GetMsgID = getMsgID.send();
        if (!rsp2GetMsgID.getFeedback()[0][1].startsWith("0")) {
            // empty if block
        }
        Addressee user_2 = new Addressee(null, Tools.createCertificate((InputStream)this.getClass().getResourceAsStream("/de/osci/osci12/samples/zertifikate/bob_cipher_4096.cer")));
        ForwardDelivery forwardDel = new ForwardDelivery(clientDialog, user_2, urlRecipient, rsp2GetMsgID.getMessageId());
        forwardDel.setSubject("Subject");
        ContentContainer data = new ContentContainer();
        data.addContent(new Content("Any content data."));
        data.addContent(new Content(new Attachment((InputStream)new ByteArrayInputStream("Any attached data".getBytes()), "attachment_id")));
        forwardDel.addContentContainer(data);
        ResponseToForwardDelivery rsp2FwdDel = forwardDel.send();
        if (!rsp2FwdDel.getFeedback()[0][1].startsWith("0")) {
            // empty if block
        }
        return rsp2FwdDel;
    }

    public static void main(String[] args) {
        try {
            String intermedUrl = args.length > 0 && args[0] != null ? args[0] : "http://gov.test.osci.de/osci-manager-entry/externalentry";
            String backendUrl = args.length > 1 && args[1] != null ? args[1] : "http://gov.test.osci.de/osci-backend-entry/externalentry";
            OneWayMessage_PassiveRecipient scenario_2 = new OneWayMessage_PassiveRecipient(intermedUrl);
            ResponseToForwardDelivery responseForward = scenario_2.sendForwardDelivery(backendUrl);
            System.out.println("\nResponseToForwardDelivery:\n" + responseForward.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

