/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.samples;

import de.osci.helper.Tools;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.encryption.Crypto;
import de.osci.osci12.extinterfaces.TransportI;
import de.osci.osci12.extinterfaces.crypto.Decrypter;
import de.osci.osci12.extinterfaces.crypto.Signer;
import de.osci.osci12.messageparts.Attachment;
import de.osci.osci12.messageparts.ChunkInformation;
import de.osci.osci12.messageparts.Content;
import de.osci.osci12.messageparts.ContentContainer;
import de.osci.osci12.messageparts.EncryptedDataOSCI;
import de.osci.osci12.messagetypes.ExitDialog;
import de.osci.osci12.messagetypes.GetMessageId;
import de.osci.osci12.messagetypes.InitDialog;
import de.osci.osci12.messagetypes.PartialFetchDelivery;
import de.osci.osci12.messagetypes.PartialStoreDelivery;
import de.osci.osci12.messagetypes.ResponseToFetchAbstract;
import de.osci.osci12.messagetypes.ResponseToFetchDelivery;
import de.osci.osci12.messagetypes.ResponseToGetMessageId;
import de.osci.osci12.messagetypes.ResponseToInitDialog;
import de.osci.osci12.messagetypes.ResponseToPartialFetchDelivery;
import de.osci.osci12.messagetypes.ResponseToPartialStoreDelivery;
import de.osci.osci12.messagetypes.StoreDelivery;
import de.osci.osci12.roles.Addressee;
import de.osci.osci12.roles.Intermed;
import de.osci.osci12.roles.Originator;
import de.osci.osci12.roles.Reader;
import de.osci.osci12.roles.Role;
import de.osci.osci12.samples.ChunkHelper;
import de.osci.osci12.samples.impl.HttpTransport;
import de.osci.osci12.samples.impl.crypto.PKCS12Decrypter;
import de.osci.osci12.samples.impl.crypto.PKCS12Signer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Random;
import javax.crypto.SecretKey;

public class PartialOneWayMessage_ActiveRecipient {
    Intermed intermed;
    public static int attCounter;

    public PartialOneWayMessage_ActiveRecipient(String intermedURL) throws CertificateException, URISyntaxException {
        X509Certificate intermedCipherCert = Tools.createCertificate((InputStream)this.getClass().getResourceAsStream("/de/osci/osci12/samples/zertifikate/osci_manager_cipher_4096.cer"));
        this.intermed = new Intermed(null, intermedCipherCert, new URI(intermedURL));
    }

    public String sendPartialStoreDelivery() throws GeneralSecurityException, IOException, OSCIException {
        Originator user1 = new Originator((Signer)new PKCS12Signer("/de/osci/osci12/samples/zertifikate/alice_signature_4096.p12", "123456"), (Decrypter)new PKCS12Decrypter("/de/osci/osci12/samples/zertifikate/carol_cipher_4096.p12", "123456"));
        DialogHandler clientDialog = new DialogHandler(user1, this.intermed, (TransportI)new HttpTransport());
        InitDialog id = new InitDialog(clientDialog);
        id.send();
        GetMessageId getMsgID = new GetMessageId(clientDialog);
        ResponseToGetMessageId rsp2GetMsgID = getMsgID.send();
        if (!rsp2GetMsgID.getFeedback()[0][1].startsWith("0")) {
            // empty if block
        }
        Addressee user2 = new Addressee(null, Tools.createCertificate((InputStream)this.getClass().getResourceAsStream("/de/osci/osci12/samples/zertifikate/bob_cipher_4096.cer")));
        DialogHandler strDelDialog = new DialogHandler(user1, this.intermed, (TransportI)new HttpTransport());
        StoreDelivery storeDel = new StoreDelivery(strDelDialog, user2, rsp2GetMsgID.getMessageId());
        storeDel.setSubject("Subject");
        ContentContainer notEncryptedContainer = new ContentContainer();
        this.addAttachments(notEncryptedContainer, 2000, null);
        notEncryptedContainer.sign((Role)user1);
        storeDel.addContentContainer(notEncryptedContainer);
        Reader reader = new Reader(Tools.createCertificate((InputStream)this.getClass().getResourceAsStream("/de/osci/osci12/samples/zertifikate/dave_cipher_4096.cer")));
        ContentContainer encryptedContainer = new ContentContainer();
        SecretKey secKey = Crypto.createSymKey((String)"http://www.w3.org/2009/xmlenc11#aes256-gcm");
        this.addAttachments(encryptedContainer, 2000, secKey);
        EncryptedDataOSCI encryptedData = new EncryptedDataOSCI("http://www.w3.org/2009/xmlenc11#aes256-gcm", encryptedContainer);
        encryptedData.encrypt((Role)reader);
        storeDel.addEncryptedData(encryptedData);
        long chunkSize = 1000L;
        ByteArrayOutputStream storeDelOut = new ByteArrayOutputStream();
        storeDel.writeMessage((OutputStream)storeDelOut);
        byte[] storeDelBytes = storeDelOut.toByteArray();
        long storeDelSize = storeDelBytes.length / 1024;
        ByteArrayInputStream storeDelIn = new ByteArrayInputStream(storeDelBytes);
        Path tempDir = Files.createTempDirectory("partial_store_delivery", new FileAttribute[0]);
        ChunkHelper ch = new ChunkHelper(storeDelIn, tempDir.toString(), "storeDel.osci", chunkSize);
        if (!rsp2GetMsgID.getFeedback()[0][1].startsWith("0")) {
            // empty if block
        }
        ResponseToPartialStoreDelivery rsp2PartialStoreDel = null;
        int chunkNumber = ch.getNumberOfChunks();
        for (int i = 1; i <= chunkNumber; ++i) {
            ChunkInformation chunkInfo = new ChunkInformation(chunkSize, i, storeDelSize, chunkNumber);
            PartialStoreDelivery parStoreDelivery = new PartialStoreDelivery(clientDialog, user2, chunkInfo, rsp2GetMsgID.getMessageId());
            parStoreDelivery.setChunkBlob((InputStream)ch.getChunk(i));
            rsp2PartialStoreDel = parStoreDelivery.send();
            if (rsp2PartialStoreDel != null && rsp2PartialStoreDel.getFeedback()[0][1].startsWith("0")) continue;
        }
        if (rsp2PartialStoreDel == null || rsp2PartialStoreDel.getInsideFeedback() == null || !rsp2PartialStoreDel.getFeedback()[0][1].startsWith("0")) {
            // empty if block
        }
        rsp2PartialStoreDel.getProcessCardBundle();
        ch.deleteFiles();
        tempDir.toFile().delete();
        ExitDialog ed = new ExitDialog(clientDialog);
        ed.send();
        return rsp2GetMsgID.getMessageId();
    }

    public ResponseToFetchDelivery sendPartialFetchDelivery(String messageId) throws GeneralSecurityException, IOException, OSCIException {
        ResponseToFetchDelivery rsp2FetchDel;
        Originator user2 = new Originator((Signer)new PKCS12Signer("/de/osci/osci12/samples/zertifikate/bob_signature_4096.p12", "123456"), (Decrypter)new PKCS12Decrypter("/de/osci/osci12/samples/zertifikate/bob_cipher_4096.p12", "123456"));
        DialogHandler clientDialog = new DialogHandler(user2, this.intermed, (TransportI)new HttpTransport());
        InitDialog id = new InitDialog(clientDialog);
        ResponseToInitDialog rsp2InitDialog = id.send();
        if (!rsp2InitDialog.getFeedback()[0][1].startsWith("0")) {
            // empty if block
        }
        ChunkInformation chunkInfo = new ChunkInformation(1000L, 1, new Integer[0]);
        PartialFetchDelivery parFetchDel = new PartialFetchDelivery(clientDialog, chunkInfo);
        parFetchDel.setSelectionMode(0);
        parFetchDel.setSelectionRule(messageId);
        ResponseToFetchAbstract rsp2ParFetchDelAbstract = parFetchDel.send();
        if (!rsp2ParFetchDelAbstract.getFeedback()[0][1].startsWith("0")) {
            // empty if block
        }
        if (rsp2ParFetchDelAbstract instanceof ResponseToFetchDelivery) {
            rsp2FetchDel = (ResponseToFetchDelivery)rsp2ParFetchDelAbstract;
        } else {
            ResponseToPartialFetchDelivery rsp2PartialFetchDel = (ResponseToPartialFetchDelivery)rsp2ParFetchDelAbstract;
            try (ByteArrayOutputStream fetchDelOut = new ByteArrayOutputStream();){
                int bytesRead;
                byte[] buf = new byte[1024];
                InputStream in = rsp2PartialFetchDel.getChunkBlob();
                while ((bytesRead = in.read(buf)) >= 0) {
                    fetchDelOut.write(buf, 0, bytesRead);
                }
                ArrayList<Integer> receivedChunks = new ArrayList<Integer>();
                receivedChunks.add(1);
                for (int i = 2; i <= rsp2PartialFetchDel.getChunkInformation().getTotalChunkNumbers(); ++i) {
                    chunkInfo.setChunkNumber(i);
                    chunkInfo.setReceivedChunks(receivedChunks);
                    parFetchDel = new PartialFetchDelivery(clientDialog, chunkInfo);
                    parFetchDel.setSelectionRule(messageId);
                    parFetchDel.setSelectionMode(0);
                    rsp2PartialFetchDel = (ResponseToPartialFetchDelivery)parFetchDel.send();
                    if (!rsp2PartialFetchDel.getFeedback()[0][1].startsWith("0")) {
                        // empty if block
                    }
                    in = rsp2PartialFetchDel.getChunkBlob();
                    while ((bytesRead = in.read(buf)) >= 0) {
                        fetchDelOut.write(buf, 0, bytesRead);
                    }
                    receivedChunks.add(i);
                }
                try (ByteArrayInputStream fetchDelIn = new ByteArrayInputStream(fetchDelOut.toByteArray());){
                    rsp2FetchDel = ResponseToFetchDelivery.parseResponseToFetchDelivery((InputStream)fetchDelIn);
                }
            }
        }
        ExitDialog ed = new ExitDialog(clientDialog);
        ed.send();
        return rsp2FetchDel;
    }

    private void addAttachments(ContentContainer coco, int sizeKB, SecretKey secKey) throws IOException, IllegalArgumentException, NoSuchAlgorithmException {
        byte[] randomBytes = new byte[sizeKB * 1024 / 3];
        new Random().nextBytes(randomBytes);
        coco.addContent(new Content("Any content data."));
        if (secKey == null) {
            coco.addContent(new Content(new Attachment((InputStream)new ByteArrayInputStream(randomBytes), "random" + attCounter++ + ".txt")));
            coco.addContent(new Content(new Attachment((InputStream)new ByteArrayInputStream(randomBytes), "random" + attCounter++ + ".txt")));
            coco.addContent(new Content(new Attachment((InputStream)new ByteArrayInputStream(randomBytes), "random" + attCounter++ + ".txt")));
        } else {
            coco.addContent(new Content(new Attachment((InputStream)new ByteArrayInputStream(randomBytes), "random" + attCounter++ + ".txt", secKey, "http://www.w3.org/2009/xmlenc11#aes256-gcm")));
            coco.addContent(new Content(new Attachment((InputStream)new ByteArrayInputStream(randomBytes), "random" + attCounter++ + ".txt", secKey, "http://www.w3.org/2009/xmlenc11#aes256-gcm")));
            coco.addContent(new Content(new Attachment((InputStream)new ByteArrayInputStream(randomBytes), "random" + attCounter++ + ".txt", secKey, "http://www.w3.org/2009/xmlenc11#aes256-gcm")));
        }
    }

    public static void main(String[] args) {
        try {
            String intermedUrl = args.length > 0 && args[0] != null ? args[0] : "http://gov.test.osci.de/osci-manager-entry/externalentry";
            PartialOneWayMessage_ActiveRecipient scenario1 = new PartialOneWayMessage_ActiveRecipient(intermedUrl);
            String storeDelMsgId = scenario1.sendPartialStoreDelivery();
            ResponseToFetchDelivery responseFetchDel = scenario1.sendPartialFetchDelivery(storeDelMsgId);
            responseFetchDel.getContentContainer();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

