/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.samples;

import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.common.OSCIErrorException;
import de.osci.osci12.common.OSCIExceptionCodes;
import de.osci.osci12.common.SoapClientException;
import de.osci.osci12.common.SoapServerException;
import de.osci.osci12.extinterfaces.crypto.Decrypter;
import de.osci.osci12.extinterfaces.crypto.Signer;
import de.osci.osci12.messageparts.Content;
import de.osci.osci12.messageparts.ContentContainer;
import de.osci.osci12.messagetypes.AcceptDelivery;
import de.osci.osci12.messagetypes.OSCIRequest;
import de.osci.osci12.messagetypes.PassiveRecipientParser;
import de.osci.osci12.messagetypes.ProcessDelivery;
import de.osci.osci12.messagetypes.ResponseToAcceptDelivery;
import de.osci.osci12.messagetypes.ResponseToProcessDelivery;
import de.osci.osci12.messagetypes.SOAPFault;
import de.osci.osci12.roles.Addressee;
import de.osci.osci12.samples.impl.crypto.PKCS12Decrypter;
import de.osci.osci12.samples.impl.crypto.PKCS12Signer;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PassiveRecipient
extends HttpServlet {
    private PassiveRecipientParser userParser;

    private void sendSOAPError(OutputStream out, String code) throws IOException {
        new SOAPFault(code).writeToStream(out);
        out.close();
    }

    public void init() throws ServletException {
        try {
            Addressee addresse = new Addressee((Signer)new PKCS12Signer("/de/osci/osci12/samples/zertifikate/bob_signature_4096.p12", "123456"), (Decrypter)new PKCS12Decrypter("/de/osci/osci12/samples/zertifikate/bob_cipher_4096.p12", "123456"));
            DialogHandler.setDefaultSupplier((Addressee)addresse);
            this.userParser = new PassiveRecipientParser();
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ResponseToProcessDelivery responseMessage = null;
        String feedback = "0800";
        OSCIRequest requestMessage = null;
        try {
            requestMessage = this.userParser.parseStream((InputStream)request.getInputStream());
        }
        catch (SoapServerException ex) {
            this.sendSOAPError((OutputStream)response.getOutputStream(), ex.getErrorCode());
            return;
        }
        catch (SoapClientException ex) {
            this.sendSOAPError((OutputStream)response.getOutputStream(), ex.getErrorCode());
            return;
        }
        catch (OSCIErrorException ex) {
            ex.printStackTrace();
            feedback = ex.getErrorCode();
            requestMessage = (OSCIRequest)ex.getOSCIMessage();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            feedback = OSCIExceptionCodes.OSCIErrorCodes.InternalErrorSupplier.getOSCICode();
            this.sendSOAPError((OutputStream)response.getOutputStream(), OSCIExceptionCodes.OSCIErrorCodes.SoapServerInternalErrorSupplier.getOSCICode());
            return;
        }
        try {
            switch (requestMessage.getMessageType()) {
                case 9: {
                    ProcessDelivery procDel = (ProcessDelivery)requestMessage;
                    ResponseToProcessDelivery rsp2procDel = new ResponseToProcessDelivery(procDel);
                    if (procDel.getMessageId() != null) {
                        rsp2procDel.setMessageId(procDel.getMessageIdResponse());
                    }
                    if (feedback.startsWith("0")) {
                        for (int i = 0; i < procDel.getContentContainer().length; ++i) {
                            ContentContainer cc = new ContentContainer();
                            for (int j = 0; j < procDel.getContentContainer()[i].getContents().length; ++j) {
                                if (procDel.getContentContainer()[i].getContents()[j].getContentType() != 2) continue;
                                cc.addContent(new Content("Return received content data: " + procDel.getContentContainer()[i].getContents()[i].getContentData()));
                            }
                            rsp2procDel.addContentContainer(cc);
                        }
                        rsp2procDel.setSubject("Response data");
                    }
                    responseMessage = rsp2procDel;
                    rsp2procDel.setFeedback(new String[]{feedback});
                    if (!requestMessage.isSigned()) break;
                    rsp2procDel.sign();
                    break;
                }
                case 1: {
                    AcceptDelivery accDel = (AcceptDelivery)requestMessage;
                    ResponseToAcceptDelivery rsp2accDel = new ResponseToAcceptDelivery(accDel);
                    if (feedback.startsWith("0")) {
                        FileWriter out = new FileWriter(this.getServletContext().getRealPath("/" + accDel.getMessageId() + ".txt"));
                        for (int i = 0; i < accDel.getContentContainer().length; ++i) {
                            for (int j = 0; j < accDel.getContentContainer()[i].getContents().length; ++j) {
                                if (accDel.getContentContainer()[i].getContents()[j].getContentType() != 2) continue;
                                out.write(accDel.getContentContainer()[i].getContents()[i].getContentData());
                            }
                        }
                        out.close();
                    }
                    rsp2accDel.setFeedback(new String[]{feedback});
                    if (requestMessage.isSigned()) {
                        rsp2accDel.sign();
                    }
                    responseMessage = rsp2accDel;
                }
            }
            ServletOutputStream out = response.getOutputStream();
            if (responseMessage instanceof ResponseToAcceptDelivery) {
                ((ResponseToAcceptDelivery)responseMessage).writeToStream((OutputStream)out, null);
            } else {
                ((ResponseToProcessDelivery)responseMessage).writeToStream((OutputStream)out, null);
            }
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ServletException((Throwable)ex);
        }
    }
}

