/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.samples;

import de.osci.helper.Tools;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.extinterfaces.TransportI;
import de.osci.osci12.extinterfaces.crypto.Decrypter;
import de.osci.osci12.extinterfaces.crypto.Signer;
import de.osci.osci12.messageparts.Attachment;
import de.osci.osci12.messageparts.Content;
import de.osci.osci12.messageparts.ContentContainer;
import de.osci.osci12.messageparts.EncryptedDataOSCI;
import de.osci.osci12.messagetypes.GetMessageId;
import de.osci.osci12.messagetypes.OSCIMessage;
import de.osci.osci12.messagetypes.ResponseToGetMessageId;
import de.osci.osci12.messagetypes.StoreDelivery;
import de.osci.osci12.messagetypes.StoredMessage;
import de.osci.osci12.roles.Addressee;
import de.osci.osci12.roles.Author;
import de.osci.osci12.roles.Intermed;
import de.osci.osci12.roles.Originator;
import de.osci.osci12.roles.Reader;
import de.osci.osci12.roles.Role;
import de.osci.osci12.samples.impl.HttpTransport;
import de.osci.osci12.samples.impl.crypto.PKCS12Decrypter;
import de.osci.osci12.samples.impl.crypto.PKCS12Signer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class SendEncryptedContent {
    private static final String PIN = "123456";

    public static void main(String[] args) throws CertificateException, NoSuchAlgorithmException, OSCIException, IOException, UnrecoverableKeyException, KeyStoreException, URISyntaxException {
        ByteArrayOutputStream msgStream = SendEncryptedContent.createEncryptedContent();
        SendEncryptedContent.sendStoreDelivery(msgStream);
    }

    private static ByteArrayOutputStream createEncryptedContent() throws IOException, NoSuchAlgorithmException, CertificateException, OSCIException {
        ContentContainer coco = SendEncryptedContent.createContentContainer();
        EncryptedDataOSCI encryptedData = new EncryptedDataOSCI("http://www.w3.org/2009/xmlenc11#aes256-gcm", coco);
        Reader reader = SendEncryptedContent.createReader();
        encryptedData.encrypt((Role)reader);
        DialogHandler dhstore = new DialogHandler((Originator)null, null, (TransportI)new HttpTransport());
        StoreDelivery storeDelivery = new StoreDelivery(dhstore, SendEncryptedContent.createAddressee(), "MyMsgId");
        storeDelivery.addEncryptedData(encryptedData);
        ByteArrayOutputStream outstrDel = new ByteArrayOutputStream();
        StoredMessage.storeMessage((OSCIMessage)storeDelivery, (OutputStream)outstrDel);
        return outstrDel;
    }

    private static void sendStoreDelivery(ByteArrayOutputStream msgStream) throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, URISyntaxException, IOException, OSCIException {
        DialogHandler senderDialog = SendEncryptedContent.createDialogHandler();
        Addressee addressee = SendEncryptedContent.createAddressee();
        String msgId = SendEncryptedContent.getMsgId(senderDialog);
        StoreDelivery storeDeliveryNext = new StoreDelivery(senderDialog, addressee, msgId);
        StoredMessage loadedMsg = StoredMessage.loadMessage((InputStream)new ByteArrayInputStream(msgStream.toByteArray()));
        for (EncryptedDataOSCI encData : loadedMsg.encryptedData.values()) {
            storeDeliveryNext.addEncryptedData(encData);
        }
        for (Author author : loadedMsg.getOtherAuthors()) {
            storeDeliveryNext.addRole((Role)author);
        }
        for (Author author : loadedMsg.getOtherReaders()) {
            storeDeliveryNext.addRole((Role)author);
        }
        storeDeliveryNext.attachments = loadedMsg.attachments;
        storeDeliveryNext.send((OutputStream)msgStream, null);
    }

    private static DialogHandler createDialogHandler() throws UnrecoverableKeyException, CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, URISyntaxException {
        Intermed intermed = SendEncryptedContent.createIntermed();
        Originator originator = SendEncryptedContent.createOriginator();
        return new DialogHandler(originator, intermed, (TransportI)new HttpTransport());
    }

    private static Intermed createIntermed() throws CertificateException, URISyntaxException {
        X509Certificate cipherCert = SendEncryptedContent.createIntermedCipherCert();
        URI uri = SendEncryptedContent.createIntermedUri();
        return new Intermed(null, cipherCert, uri);
    }

    private static X509Certificate createIntermedCipherCert() throws CertificateException {
        String testCypher = "/de/osci/osci12/samples/zertifikate/osci_manager_cipher_4096.cer";
        InputStream resource = SendEncryptedContent.getResource("/de/osci/osci12/samples/zertifikate/osci_manager_cipher_4096.cer");
        return Tools.createCertificate((InputStream)resource);
    }

    private static InputStream getResource(String resource) {
        return SendEncryptedContent.class.getResourceAsStream(resource);
    }

    private static URI createIntermedUri() throws URISyntaxException {
        String testEntry = "http://gov.test.osci.de/osci-manager-entry/externalentry";
        return new URI("http://gov.test.osci.de/osci-manager-entry/externalentry");
    }

    private static Originator createOriginator() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, UnrecoverableKeyException {
        Signer signer = SendEncryptedContent.createSigner();
        Decrypter decrypter = SendEncryptedContent.createDecrypter();
        return new Originator(signer, decrypter);
    }

    private static Signer createSigner() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        String cert = "/de/osci/osci12/samples/zertifikate/alice_signature_4096.p12";
        return new PKCS12Signer("/de/osci/osci12/samples/zertifikate/alice_signature_4096.p12", PIN);
    }

    private static Decrypter createDecrypter() throws UnrecoverableKeyException, CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        String cert = "/de/osci/osci12/samples/zertifikate/carol_cipher_4096.p12";
        return new PKCS12Decrypter("/de/osci/osci12/samples/zertifikate/carol_cipher_4096.p12", PIN);
    }

    private static Addressee createAddressee() throws CertificateException {
        String cert = "/de/osci/osci12/samples/zertifikate/bob_cipher_4096.cer";
        InputStream resource = SendEncryptedContent.getResource("/de/osci/osci12/samples/zertifikate/bob_cipher_4096.cer");
        return new Addressee(null, Tools.createCertificate((InputStream)resource));
    }

    private static ContentContainer createContentContainer() throws IOException, NoSuchAlgorithmException {
        ContentContainer coco = new ContentContainer();
        coco.addContent(new Content("Any encrypted content data."));
        coco.addContent(new Content(SendEncryptedContent.anyAttachment()));
        return coco;
    }

    private static Attachment anyAttachment() throws IOException, NoSuchAlgorithmException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream("Any encrypted attachment data.".getBytes());
        String refId = "enc_test.txt";
        return new Attachment((InputStream)inputStream, "enc_test.txt", "http://www.w3.org/2009/xmlenc11#aes256-gcm");
    }

    private static Reader createReader() throws CertificateException {
        String cert = "/de/osci/osci12/samples/zertifikate/dave_cipher_4096.cer";
        InputStream resource = SendEncryptedContent.getResource("/de/osci/osci12/samples/zertifikate/dave_cipher_4096.cer");
        return new Reader(Tools.createCertificate((InputStream)resource));
    }

    private static String getMsgId(DialogHandler dh) throws OSCIException, NoSuchAlgorithmException, IOException {
        GetMessageId getMsgId = new GetMessageId(dh);
        ResponseToGetMessageId rsp2GetMsgID = getMsgId.send();
        return rsp2GetMsgID.getMessageId();
    }
}

